/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodValue;

public class TimePeriodValueTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(TimePeriodValueTests.class);
    }

    public TimePeriodValueTests(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testEqualsSelf() {
        TimePeriodValue tpv = new TimePeriodValue((TimePeriod)new Day(), 55.75);
        TimePeriodValueTests.assertTrue((boolean)tpv.equals(tpv));
    }

    public void testEquals() {
        TimePeriodValue tpv1 = new TimePeriodValue((TimePeriod)new Day(30, 7, 2003), 55.75);
        TimePeriodValue tpv2 = new TimePeriodValue((TimePeriod)new Day(30, 7, 2003), 55.75);
        TimePeriodValueTests.assertTrue((boolean)tpv1.equals(tpv2));
        TimePeriodValueTests.assertTrue((boolean)tpv2.equals(tpv1));
    }

    public void testSerialization() {
        TimePeriodValue tpv1 = new TimePeriodValue((TimePeriod)new Day(30, 7, 2003), 55.75);
        TimePeriodValue tpv2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(tpv1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            tpv2 = (TimePeriodValue)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        TimePeriodValueTests.assertEquals((Object)tpv1, tpv2);
    }
}

