/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics.junit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.statistics.Regression;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class RegressionTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(RegressionTests.class);
    }

    public RegressionTests(String name) {
        super(name);
    }

    public void testOLSRegression1a() {
        double[][] data = this.createSampleData1();
        double[] result1 = Regression.getOLSRegression(data);
        RegressionTests.assertEquals((double)0.2568093, (double)result1[0], (double)1.0E-7);
        RegressionTests.assertEquals((double)0.72792106, (double)result1[1], (double)1.0E-7);
    }

    public void testOLSRegression1b() {
        double[][] data = this.createSampleData1();
        XYSeries series = new XYSeries((Comparable)((Object)"Test"));
        for (int i = 0; i < 11; ++i) {
            series.add(data[i][0], data[i][1]);
        }
        XYSeriesCollection ds = new XYSeriesCollection(series);
        double[] result2 = Regression.getOLSRegression(ds, 0);
        RegressionTests.assertEquals((double)0.2568093, (double)result2[0], (double)1.0E-7);
        RegressionTests.assertEquals((double)0.72792106, (double)result2[1], (double)1.0E-7);
    }

    public void testPowerRegression1a() {
        double[][] data = this.createSampleData1();
        double[] result = Regression.getPowerRegression(data);
        RegressionTests.assertEquals((double)0.91045813, (double)result[0], (double)1.0E-7);
        RegressionTests.assertEquals((double)0.88918346, (double)result[1], (double)1.0E-7);
    }

    public void testPowerRegression1b() {
        double[][] data = this.createSampleData1();
        XYSeries series = new XYSeries((Comparable)((Object)"Test"));
        for (int i = 0; i < 11; ++i) {
            series.add(data[i][0], data[i][1]);
        }
        XYSeriesCollection ds = new XYSeriesCollection(series);
        double[] result = Regression.getPowerRegression(ds, 0);
        RegressionTests.assertEquals((double)0.91045813, (double)result[0], (double)1.0E-7);
        RegressionTests.assertEquals((double)0.88918346, (double)result[1], (double)1.0E-7);
    }

    public void testOLSRegression2a() {
        double[][] data = this.createSampleData2();
        double[] result = Regression.getOLSRegression(data);
        RegressionTests.assertEquals((double)53.9729697, (double)result[0], (double)1.0E-7);
        RegressionTests.assertEquals((double)-4.182303, (double)result[1], (double)1.0E-7);
    }

    public void testOLSRegression2b() {
        double[][] data = this.createSampleData2();
        XYSeries series = new XYSeries((Comparable)((Object)"Test"));
        for (int i = 0; i < 10; ++i) {
            series.add(data[i][0], data[i][1]);
        }
        XYSeriesCollection ds = new XYSeriesCollection(series);
        double[] result = Regression.getOLSRegression(ds, 0);
        RegressionTests.assertEquals((double)53.9729697, (double)result[0], (double)1.0E-7);
        RegressionTests.assertEquals((double)-4.182303, (double)result[1], (double)1.0E-7);
    }

    public void testPowerRegression2a() {
        double[][] data = this.createSampleData2();
        double[] result = Regression.getPowerRegression(data);
        RegressionTests.assertEquals((double)106.1241681, (double)result[0], (double)1.0E-7);
        RegressionTests.assertEquals((double)-0.8466615, (double)result[1], (double)1.0E-7);
    }

    public void testPowerRegression2b() {
        double[][] data = this.createSampleData2();
        XYSeries series = new XYSeries((Comparable)((Object)"Test"));
        for (int i = 0; i < 10; ++i) {
            series.add(data[i][0], data[i][1]);
        }
        XYSeriesCollection ds = new XYSeriesCollection(series);
        double[] result = Regression.getPowerRegression(ds, 0);
        RegressionTests.assertEquals((double)106.1241681, (double)result[0], (double)1.0E-7);
        RegressionTests.assertEquals((double)-0.8466615, (double)result[1], (double)1.0E-7);
    }

    private double[][] createSampleData1() {
        double[][] result = new double[11][2];
        result[0][0] = 2.0;
        result[0][1] = 1.6;
        result[1][0] = 2.25;
        result[1][1] = 2.0;
        result[2][0] = 2.6;
        result[2][1] = 1.8;
        result[3][0] = 2.65;
        result[3][1] = 2.8;
        result[4][0] = 2.8;
        result[4][1] = 2.1;
        result[5][0] = 3.1;
        result[5][1] = 2.0;
        result[6][0] = 2.9;
        result[6][1] = 2.65;
        result[7][0] = 3.25;
        result[7][1] = 2.25;
        result[8][0] = 3.3;
        result[8][1] = 2.6;
        result[9][0] = 3.6;
        result[9][1] = 3.0;
        result[10][0] = 3.25;
        result[10][1] = 3.1;
        return result;
    }

    private double[][] createSampleData2() {
        double[][] result = new double[10][2];
        result[0][0] = 2.0;
        result[0][1] = 56.27;
        result[1][0] = 3.0;
        result[1][1] = 41.32;
        result[2][0] = 4.0;
        result[2][1] = 31.45;
        result[3][0] = 5.0;
        result[3][1] = 30.05;
        result[4][0] = 6.0;
        result[4][1] = 24.69;
        result[5][0] = 7.0;
        result[5][1] = 19.78;
        result[6][0] = 8.0;
        result[6][1] = 20.94;
        result[7][0] = 9.0;
        result[7][1] = 16.73;
        result[8][0] = 10.0;
        result[8][1] = 14.21;
        result[9][0] = 11.0;
        result[9][1] = 12.44;
        return result;
    }
}

