/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;

public class DefaultStatisticalCategoryDatasetTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(DefaultStatisticalCategoryDatasetTests.class);
    }

    public DefaultStatisticalCategoryDatasetTests(String name) {
        super(name);
    }

    public void testEquals() {
        DefaultStatisticalCategoryDataset d1 = new DefaultStatisticalCategoryDataset();
        DefaultStatisticalCategoryDataset d2 = new DefaultStatisticalCategoryDataset();
        DefaultStatisticalCategoryDatasetTests.assertTrue((boolean)d1.equals(d2));
        DefaultStatisticalCategoryDatasetTests.assertTrue((boolean)d2.equals(d1));
    }

    public void testCloning() {
        DefaultStatisticalCategoryDataset d1 = new DefaultStatisticalCategoryDataset();
        d1.add(1.1, 2.2, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        d1.add(3.3, 4.4, (Comparable)((Object)"R1"), (Comparable)((Object)"C2"));
        d1.add(null, new Double(5.5), (Comparable)((Object)"R1"), (Comparable)((Object)"C3"));
        d1.add(new Double(6.6), null, (Comparable)((Object)"R2"), (Comparable)((Object)"C3"));
        DefaultStatisticalCategoryDataset d2 = null;
        try {
            d2 = (DefaultStatisticalCategoryDataset)d1.clone();
        }
        catch (CloneNotSupportedException e) {
            DefaultStatisticalCategoryDatasetTests.fail((String)e.toString());
        }
        DefaultStatisticalCategoryDatasetTests.assertTrue((d1 != d2 ? 1 : 0) != 0);
        DefaultStatisticalCategoryDatasetTests.assertTrue((d1.getClass() == d2.getClass() ? 1 : 0) != 0);
        DefaultStatisticalCategoryDatasetTests.assertTrue((boolean)d1.equals(d2));
    }

    public void testSerialization1() {
        DefaultStatisticalCategoryDataset d1 = new DefaultStatisticalCategoryDataset();
        d1.add(1.1, 2.2, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        d1.add(3.3, 4.4, (Comparable)((Object)"R1"), (Comparable)((Object)"C2"));
        d1.add(null, new Double(5.5), (Comparable)((Object)"R1"), (Comparable)((Object)"C3"));
        d1.add(new Double(6.6), null, (Comparable)((Object)"R2"), (Comparable)((Object)"C3"));
        DefaultStatisticalCategoryDataset d2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(d1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            d2 = (DefaultStatisticalCategoryDataset)in.readObject();
            in.close();
        }
        catch (Exception e) {
            DefaultStatisticalCategoryDatasetTests.fail((String)e.toString());
        }
        DefaultStatisticalCategoryDatasetTests.assertEquals((Object)d1, d2);
    }

    public void testSerialization2() {
        DefaultStatisticalCategoryDataset d1 = new DefaultStatisticalCategoryDataset();
        d1.add(1.2, 3.4, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 1"));
        DefaultStatisticalCategoryDataset d2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(d1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            d2 = (DefaultStatisticalCategoryDataset)in.readObject();
            in.close();
        }
        catch (Exception e) {
            DefaultStatisticalCategoryDatasetTests.fail((String)e.toString());
        }
        DefaultStatisticalCategoryDatasetTests.assertEquals((Object)d1, d2);
    }
}

