/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics.junit;

import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.statistics.BoxAndWhiskerCalculator;

public class BoxAndWhiskerCalculatorTests
extends TestCase {
    private static final double EPSILON = 1.0E-9;

    public static Test suite() {
        return new TestSuite(BoxAndWhiskerCalculatorTests.class);
    }

    public BoxAndWhiskerCalculatorTests(String name) {
        super(name);
    }

    public void testCalculateQ1() {
        ArrayList<Double> values = new ArrayList<Double>();
        double q1 = BoxAndWhiskerCalculator.calculateQ1(values);
        BoxAndWhiskerCalculatorTests.assertTrue((boolean)Double.isNaN(q1));
        values.add(new Double(1.0));
        q1 = BoxAndWhiskerCalculator.calculateQ1(values);
        BoxAndWhiskerCalculatorTests.assertEquals((double)q1, (double)1.0, (double)1.0E-9);
        values.add(new Double(2.0));
        q1 = BoxAndWhiskerCalculator.calculateQ1(values);
        BoxAndWhiskerCalculatorTests.assertEquals((double)q1, (double)1.0, (double)1.0E-9);
        values.add(new Double(3.0));
        q1 = BoxAndWhiskerCalculator.calculateQ1(values);
        BoxAndWhiskerCalculatorTests.assertEquals((double)q1, (double)1.5, (double)1.0E-9);
        values.add(new Double(4.0));
        q1 = BoxAndWhiskerCalculator.calculateQ1(values);
        BoxAndWhiskerCalculatorTests.assertEquals((double)q1, (double)1.5, (double)1.0E-9);
    }

    public void testCalculateQ3() {
        ArrayList<Double> values = new ArrayList<Double>();
        double q3 = BoxAndWhiskerCalculator.calculateQ3(values);
        BoxAndWhiskerCalculatorTests.assertTrue((boolean)Double.isNaN(q3));
        values.add(new Double(1.0));
        q3 = BoxAndWhiskerCalculator.calculateQ3(values);
        BoxAndWhiskerCalculatorTests.assertEquals((double)q3, (double)1.0, (double)1.0E-9);
        values.add(new Double(2.0));
        q3 = BoxAndWhiskerCalculator.calculateQ3(values);
        BoxAndWhiskerCalculatorTests.assertEquals((double)q3, (double)2.0, (double)1.0E-9);
        values.add(new Double(3.0));
        q3 = BoxAndWhiskerCalculator.calculateQ3(values);
        BoxAndWhiskerCalculatorTests.assertEquals((double)q3, (double)2.5, (double)1.0E-9);
        values.add(new Double(4.0));
        q3 = BoxAndWhiskerCalculator.calculateQ3(values);
        BoxAndWhiskerCalculatorTests.assertEquals((double)q3, (double)3.5, (double)1.0E-9);
    }
}

