/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.KeyedObjects;

public class KeyedObjectsTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(KeyedObjectsTests.class);
    }

    public KeyedObjectsTests(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testCloning() {
        KeyedObjects ko1 = new KeyedObjects();
        ko1.addObject((Comparable)((Object)"V1"), new Integer(1));
        ko1.addObject((Comparable)((Object)"V2"), null);
        ko1.addObject((Comparable)((Object)"V3"), new Integer(3));
        KeyedObjects ko2 = null;
        try {
            ko2 = (KeyedObjects)ko1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        KeyedObjectsTests.assertTrue((ko1 != ko2 ? 1 : 0) != 0);
        KeyedObjectsTests.assertTrue((ko1.getClass() == ko2.getClass() ? 1 : 0) != 0);
        KeyedObjectsTests.assertTrue((boolean)ko1.equals(ko2));
    }

    public void testInsertAndRetrieve() {
        KeyedObjects data = new KeyedObjects();
        data.addObject((Comparable)((Object)"A"), new Double(1.0));
        data.addObject((Comparable)((Object)"B"), new Double(2.0));
        data.addObject((Comparable)((Object)"C"), new Double(3.0));
        data.addObject((Comparable)((Object)"D"), null);
        KeyedObjectsTests.assertEquals((Object)data.getKey(0), (Object)"A");
        KeyedObjectsTests.assertEquals((Object)data.getKey(1), (Object)"B");
        KeyedObjectsTests.assertEquals((Object)data.getKey(2), (Object)"C");
        KeyedObjectsTests.assertEquals((Object)data.getKey(3), (Object)"D");
        KeyedObjectsTests.assertEquals((Object)data.getObject((Comparable)((Object)"A")), (Object)new Double(1.0));
        KeyedObjectsTests.assertEquals((Object)data.getObject((Comparable)((Object)"B")), (Object)new Double(2.0));
        KeyedObjectsTests.assertEquals((Object)data.getObject((Comparable)((Object)"C")), (Object)new Double(3.0));
        KeyedObjectsTests.assertEquals((Object)data.getObject((Comparable)((Object)"D")), null);
        KeyedObjectsTests.assertEquals((Object)data.getObject((Comparable)((Object)"Not a key")), null);
        KeyedObjectsTests.assertEquals((Object)data.getObject(0), (Object)new Double(1.0));
        KeyedObjectsTests.assertEquals((Object)data.getObject(1), (Object)new Double(2.0));
        KeyedObjectsTests.assertEquals((Object)data.getObject(2), (Object)new Double(3.0));
        KeyedObjectsTests.assertEquals((Object)data.getObject(3), null);
    }

    public void testSerialization() {
        KeyedObjects ko1 = new KeyedObjects();
        ko1.addObject((Comparable)((Object)"Key 1"), "Object 1");
        ko1.addObject((Comparable)((Object)"Key 2"), null);
        ko1.addObject((Comparable)((Object)"Key 3"), "Object 2");
        KeyedObjects ko2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(ko1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            ko2 = (KeyedObjects)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        KeyedObjectsTests.assertEquals((Object)ko1, ko2);
    }
}

