/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.general.DefaultKeyedValuesDataset;
import org.jfree.data.general.KeyedValuesDataset;

public class DefaultKeyedValuesDatasetTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(DefaultKeyedValuesDatasetTests.class);
    }

    public DefaultKeyedValuesDatasetTests(String name) {
        super(name);
    }

    public void testCloning() {
        DefaultKeyedValuesDataset d1 = new DefaultKeyedValuesDataset();
        d1.setValue((Comparable)((Object)"V1"), new Integer(1));
        d1.setValue((Comparable)((Object)"V2"), null);
        d1.setValue((Comparable)((Object)"V3"), new Integer(3));
        DefaultKeyedValuesDataset d2 = null;
        try {
            d2 = (DefaultKeyedValuesDataset)d1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        DefaultKeyedValuesDatasetTests.assertTrue((d1 != d2 ? 1 : 0) != 0);
        DefaultKeyedValuesDatasetTests.assertTrue((d1.getClass() == d2.getClass() ? 1 : 0) != 0);
        DefaultKeyedValuesDatasetTests.assertTrue((boolean)d1.equals(d2));
    }

    public void testSerialization() {
        DefaultKeyedValuesDataset d1 = new DefaultKeyedValuesDataset();
        d1.setValue((Comparable)((Object)"C1"), new Double(234.2));
        d1.setValue((Comparable)((Object)"C2"), null);
        d1.setValue((Comparable)((Object)"C3"), new Double(345.9));
        d1.setValue((Comparable)((Object)"C4"), new Double(452.7));
        KeyedValuesDataset d2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(d1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            d2 = (KeyedValuesDataset)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        DefaultKeyedValuesDatasetTests.assertEquals((Object)d1, d2);
    }
}

