/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.gantt.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.gantt.Task;
import org.jfree.data.time.SimpleTimePeriod;

public class TaskTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(TaskTests.class);
    }

    public TaskTests(String name) {
        super(name);
    }

    public void testEquals() {
        Task t1 = new Task("T", new Date(1L), new Date(2L));
        Task t2 = new Task("T", new Date(1L), new Date(2L));
        TaskTests.assertTrue((boolean)t1.equals(t2));
        TaskTests.assertTrue((boolean)t2.equals(t1));
        t1.setDescription("X");
        TaskTests.assertFalse((boolean)t1.equals(t2));
        t2.setDescription("X");
        TaskTests.assertTrue((boolean)t1.equals(t2));
        t1.setDuration(new SimpleTimePeriod(new Date(2L), new Date(3L)));
        TaskTests.assertFalse((boolean)t1.equals(t2));
        t2.setDuration(new SimpleTimePeriod(new Date(2L), new Date(3L)));
        TaskTests.assertTrue((boolean)t1.equals(t2));
        t1.setPercentComplete(0.5);
        TaskTests.assertFalse((boolean)t1.equals(t2));
        t2.setPercentComplete(0.5);
        TaskTests.assertTrue((boolean)t1.equals(t2));
        t1.addSubtask(new Task("T", new Date(22L), new Date(33L)));
        TaskTests.assertFalse((boolean)t1.equals(t2));
        t2.addSubtask(new Task("T", new Date(22L), new Date(33L)));
        TaskTests.assertTrue((boolean)t1.equals(t2));
    }

    public void testCloning() {
        Task t1 = new Task("T", new Date(1L), new Date(2L));
        Task t2 = null;
        try {
            t2 = (Task)t1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        TaskTests.assertTrue((t1 != t2 ? 1 : 0) != 0);
        TaskTests.assertTrue((t1.getClass() == t2.getClass() ? 1 : 0) != 0);
        TaskTests.assertTrue((boolean)t1.equals(t2));
    }

    public void testSerialization() {
        Task t1 = new Task("T", new Date(1L), new Date(2L));
        Task t2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(t1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            t2 = (Task)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        TaskTests.assertEquals((Object)t1, t2);
    }

    public void testGetSubTaskCount() {
        Task t1 = new Task("T", new Date(100L), new Date(200L));
        TaskTests.assertEquals((int)0, (int)t1.getSubtaskCount());
        t1.addSubtask(new Task("S1", new Date(100L), new Date(110L)));
        TaskTests.assertEquals((int)1, (int)t1.getSubtaskCount());
        Task s2 = new Task("S2", new Date(111L), new Date(120L));
        t1.addSubtask(s2);
        TaskTests.assertEquals((int)2, (int)t1.getSubtaskCount());
        t1.addSubtask(new Task("S3", new Date(121L), new Date(130L)));
        TaskTests.assertEquals((int)3, (int)t1.getSubtaskCount());
        t1.removeSubtask(s2);
        TaskTests.assertEquals((int)2, (int)t1.getSubtaskCount());
    }
}

