/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.urls.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.urls.StandardPieURLGenerator;
import org.jfree.data.general.DefaultPieDataset;

public class StandardPieURLGeneratorTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(StandardPieURLGeneratorTests.class);
    }

    public StandardPieURLGeneratorTests(String name) {
        super(name);
    }

    public void testSerialization() {
        StandardPieURLGenerator g1 = new StandardPieURLGenerator("index.html?", "cat");
        StandardPieURLGenerator g2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(g1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            g2 = (StandardPieURLGenerator)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        StandardPieURLGeneratorTests.assertEquals((Object)g1, g2);
    }

    public void testURL() {
        DefaultPieDataset dataset = new DefaultPieDataset();
        dataset.setValue((Comparable)((Object)"Alpha"), new Double(5.0));
        dataset.setValue((Comparable)((Object)"Beta"), new Double(5.5));
        StandardPieURLGenerator g1 = new StandardPieURLGenerator("chart.jsp", "category");
        String url = g1.generateURL(dataset, (Comparable)((Object)"Beta"), 0);
        StandardPieURLGeneratorTests.assertEquals((String)"chart.jsp?category=Beta&amp;pieIndex=0", (String)url);
    }
}

