/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.title.junit;

import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.title.TextTitle;

public class TextTitleTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(TextTitleTests.class);
    }

    public TextTitleTests(String name) {
        super(name);
    }

    public void testEquals() {
        TextTitle t1 = new TextTitle();
        TextTitle t2 = new TextTitle();
        TextTitleTests.assertEquals((Object)t1, (Object)t2);
        t1.setText("Test 1");
        TextTitleTests.assertFalse((boolean)t1.equals(t2));
        t2.setText("Test 1");
        TextTitleTests.assertTrue((boolean)t1.equals(t2));
        Font f = new Font("SansSerif", 0, 15);
        t1.setFont(f);
        TextTitleTests.assertFalse((boolean)t1.equals(t2));
        t2.setFont(f);
        TextTitleTests.assertTrue((boolean)t1.equals(t2));
        t1.setPaint(Color.blue);
        TextTitleTests.assertFalse((boolean)t1.equals(t2));
        t2.setPaint(Color.blue);
        TextTitleTests.assertTrue((boolean)t1.equals(t2));
        t1.setBackgroundPaint(Color.blue);
        TextTitleTests.assertFalse((boolean)t1.equals(t2));
        t2.setBackgroundPaint(Color.blue);
        TextTitleTests.assertTrue((boolean)t1.equals(t2));
    }

    public void testHashcode() {
        TextTitle t1 = new TextTitle();
        TextTitle t2 = new TextTitle();
        TextTitleTests.assertTrue((boolean)t1.equals(t2));
        int h1 = t1.hashCode();
        int h2 = t2.hashCode();
        TextTitleTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        TextTitle t1 = new TextTitle();
        TextTitle t2 = null;
        try {
            t2 = (TextTitle)t1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("TextTitleTests.testCloning: failed to clone.");
        }
        TextTitleTests.assertTrue((t1 != t2 ? 1 : 0) != 0);
        TextTitleTests.assertTrue((t1.getClass() == t2.getClass() ? 1 : 0) != 0);
        TextTitleTests.assertTrue((boolean)t1.equals(t2));
    }

    public void testSerialization() {
        TextTitle t1 = new TextTitle("Test");
        TextTitle t2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(t1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            t2 = (TextTitle)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        TextTitleTests.assertEquals((Object)t1, t2);
    }
}

