/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy.junit;

import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.junit.RendererXYPackageTests;
import org.jfree.data.Range;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.StandardGradientPaintTransformer;

public class XYBarRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYBarRendererTests.class);
    }

    public XYBarRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        XYBarRenderer r1 = new XYBarRenderer();
        XYBarRenderer r2 = new XYBarRenderer();
        XYBarRendererTests.assertTrue((boolean)r1.equals(r2));
        XYBarRendererTests.assertTrue((boolean)r2.equals(r1));
        r1.setBase(1.0);
        XYBarRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setBase(1.0);
        XYBarRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setUseYInterval(!r1.getUseYInterval());
        XYBarRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setUseYInterval(!r2.getUseYInterval());
        XYBarRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setMargin(0.1);
        XYBarRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setMargin(0.1);
        XYBarRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setDrawBarOutline(!r1.isDrawBarOutline());
        XYBarRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setDrawBarOutline(!r2.isDrawBarOutline());
        XYBarRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(GradientPaintTransformType.CENTER_HORIZONTAL));
        XYBarRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(GradientPaintTransformType.CENTER_HORIZONTAL));
        XYBarRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setLegendBar(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0));
        XYBarRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setLegendBar(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0));
        XYBarRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testHashcode() {
        XYBarRenderer r1 = new XYBarRenderer();
        XYBarRenderer r2 = new XYBarRenderer();
        XYBarRendererTests.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        XYBarRendererTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        XYBarRenderer r1 = new XYBarRenderer();
        XYBarRenderer r2 = null;
        try {
            r2 = (XYBarRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        XYBarRendererTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        XYBarRendererTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        XYBarRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        XYBarRenderer r1 = new XYBarRenderer();
        XYBarRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (XYBarRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        XYBarRendererTests.assertEquals((Object)r1, r2);
    }

    public void testFindDomainBounds() {
        XYSeriesCollection dataset = RendererXYPackageTests.createTestXYSeriesCollection();
        JFreeChart chart = ChartFactory.createXYBarChart("Test Chart", "X", false, "Y", dataset, PlotOrientation.VERTICAL, false, false, false);
        XYPlot plot = (XYPlot)chart.getPlot();
        NumberAxis domainAxis = (NumberAxis)plot.getDomainAxis();
        domainAxis.setAutoRangeIncludesZero(false);
        Range bounds = domainAxis.getRange();
        XYBarRendererTests.assertFalse((boolean)bounds.contains(0.3));
        XYBarRendererTests.assertTrue((boolean)bounds.contains(0.5));
        XYBarRendererTests.assertTrue((boolean)bounds.contains(2.5));
        XYBarRendererTests.assertFalse((boolean)bounds.contains(2.8));
    }
}

