/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy.junit;

import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.xy.XYAreaRenderer;

public class XYAreaRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYAreaRendererTests.class);
    }

    public XYAreaRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        XYAreaRenderer r1 = new XYAreaRenderer();
        XYAreaRenderer r2 = new XYAreaRenderer();
        XYAreaRendererTests.assertEquals((Object)r1, (Object)r2);
        r1 = new XYAreaRenderer(5);
        XYAreaRendererTests.assertFalse((boolean)r1.equals(r2));
        r2 = new XYAreaRenderer(5);
        XYAreaRendererTests.assertTrue((boolean)r1.equals(r2));
        r1 = new XYAreaRenderer(4);
        XYAreaRendererTests.assertFalse((boolean)r1.equals(r2));
        r2 = new XYAreaRenderer(4);
        XYAreaRendererTests.assertTrue((boolean)r1.equals(r2));
        r1 = new XYAreaRenderer(2);
        XYAreaRendererTests.assertFalse((boolean)r1.equals(r2));
        r2 = new XYAreaRenderer(2);
        XYAreaRendererTests.assertTrue((boolean)r1.equals(r2));
        r1 = new XYAreaRenderer(1);
        XYAreaRendererTests.assertFalse((boolean)r1.equals(r2));
        r2 = new XYAreaRenderer(1);
        XYAreaRendererTests.assertTrue((boolean)r1.equals(r2));
        r1 = new XYAreaRenderer(3);
        XYAreaRendererTests.assertFalse((boolean)r1.equals(r2));
        r2 = new XYAreaRenderer(3);
        XYAreaRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setOutline(true);
        XYAreaRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setOutline(true);
        XYAreaRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setLegendArea(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0));
        XYAreaRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setLegendArea(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0));
        XYAreaRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testHashcode() {
        XYAreaRenderer r1 = new XYAreaRenderer();
        XYAreaRenderer r2 = new XYAreaRenderer();
        XYAreaRendererTests.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        XYAreaRendererTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        XYAreaRenderer r1 = new XYAreaRenderer();
        XYAreaRenderer r2 = null;
        try {
            r2 = (XYAreaRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        XYAreaRendererTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        XYAreaRendererTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        XYAreaRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        XYAreaRenderer r1 = new XYAreaRenderer();
        XYAreaRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (XYAreaRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        XYAreaRendererTests.assertEquals((Object)r1, r2);
    }
}

