/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy.junit;

import java.awt.geom.Line2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.util.UnitType;

public class StandardXYItemRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(StandardXYItemRendererTests.class);
    }

    public StandardXYItemRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        StandardXYItemRenderer r1 = new StandardXYItemRenderer();
        StandardXYItemRenderer r2 = new StandardXYItemRenderer();
        StandardXYItemRendererTests.assertEquals((Object)r1, (Object)r2);
        r1.setPlotShapes(true);
        StandardXYItemRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setPlotShapes(true);
        StandardXYItemRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setPlotLines(false);
        StandardXYItemRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setPlotLines(false);
        StandardXYItemRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setPlotImages(true);
        StandardXYItemRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setPlotImages(true);
        StandardXYItemRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setShapesFilled(false);
        StandardXYItemRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setShapesFilled(false);
        StandardXYItemRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setGapThresholdType(UnitType.ABSOLUTE);
        StandardXYItemRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setGapThresholdType(UnitType.ABSOLUTE);
        StandardXYItemRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setGapThreshold(1.23);
        StandardXYItemRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setGapThreshold(1.23);
        StandardXYItemRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setLegendLine(new Line2D.Double(1.0, 2.0, 3.0, 4.0));
        StandardXYItemRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setLegendLine(new Line2D.Double(1.0, 2.0, 3.0, 4.0));
        StandardXYItemRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testHashcode() {
        StandardXYItemRenderer r1 = new StandardXYItemRenderer();
        StandardXYItemRenderer r2 = new StandardXYItemRenderer();
        StandardXYItemRendererTests.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        StandardXYItemRendererTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        StandardXYItemRenderer r1 = new StandardXYItemRenderer();
        StandardXYItemRenderer r2 = null;
        try {
            r2 = (StandardXYItemRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        StandardXYItemRendererTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        StandardXYItemRendererTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        StandardXYItemRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        StandardXYItemRenderer r1 = new StandardXYItemRenderer();
        StandardXYItemRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (StandardXYItemRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        StandardXYItemRendererTests.assertEquals((Object)r1, r2);
    }
}

