/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.junit.RendererXYPackageTests;
import org.jfree.data.Range;
import org.jfree.data.xy.TableXYDataset;

public class StackedXYBarRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(StackedXYBarRendererTests.class);
    }

    public StackedXYBarRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        StackedXYBarRenderer r1 = new StackedXYBarRenderer();
        StackedXYBarRenderer r2 = new StackedXYBarRenderer();
        StackedXYBarRendererTests.assertTrue((boolean)r1.equals(r2));
        StackedXYBarRendererTests.assertTrue((boolean)r2.equals(r1));
    }

    public void testHashcode() {
        StackedXYBarRenderer r1 = new StackedXYBarRenderer();
        StackedXYBarRenderer r2 = new StackedXYBarRenderer();
        StackedXYBarRendererTests.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        StackedXYBarRendererTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        StackedXYBarRenderer r1 = new StackedXYBarRenderer();
        StackedXYBarRenderer r2 = null;
        try {
            r2 = (StackedXYBarRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        StackedXYBarRendererTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        StackedXYBarRendererTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        StackedXYBarRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        StackedXYBarRenderer r1 = new StackedXYBarRenderer();
        StackedXYBarRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (StackedXYBarRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        StackedXYBarRendererTests.assertEquals((Object)r1, r2);
    }

    public void testFindDomainBounds() {
        TableXYDataset dataset = RendererXYPackageTests.createTestTableXYDataset();
        JFreeChart chart = ChartFactory.createStackedXYAreaChart("Test Chart", "X", "Y", dataset, PlotOrientation.VERTICAL, false, false, false);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setRenderer(new StackedXYBarRenderer());
        NumberAxis domainAxis = (NumberAxis)plot.getDomainAxis();
        domainAxis.setAutoRangeIncludesZero(false);
        Range bounds = domainAxis.getRange();
        StackedXYBarRendererTests.assertFalse((boolean)bounds.contains(0.3));
        StackedXYBarRendererTests.assertTrue((boolean)bounds.contains(0.5));
        StackedXYBarRendererTests.assertTrue((boolean)bounds.contains(2.5));
        StackedXYBarRendererTests.assertFalse((boolean)bounds.contains(2.8));
    }

    public void testFindRangeBounds() {
        TableXYDataset dataset = RendererXYPackageTests.createTestTableXYDataset();
        JFreeChart chart = ChartFactory.createStackedXYAreaChart("Test Chart", "X", "Y", dataset, PlotOrientation.VERTICAL, false, false, false);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setRenderer(new StackedXYBarRenderer());
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        Range bounds = rangeAxis.getRange();
        StackedXYBarRendererTests.assertTrue((boolean)bounds.contains(6.0));
        StackedXYBarRendererTests.assertTrue((boolean)bounds.contains(8.0));
    }
}

