/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.chart.renderer.xy.junit.RendererXYPackageTests;
import org.jfree.data.Range;
import org.jfree.data.xy.TableXYDataset;

public class StackedXYAreaRenderer2Tests
extends TestCase {
    public static Test suite() {
        return new TestSuite(StackedXYAreaRenderer2Tests.class);
    }

    public StackedXYAreaRenderer2Tests(String name) {
        super(name);
    }

    public void testEquals() {
        StackedXYAreaRenderer2 r1 = new StackedXYAreaRenderer2();
        StackedXYAreaRenderer2 r2 = new StackedXYAreaRenderer2();
        StackedXYAreaRenderer2Tests.assertEquals((Object)r1, (Object)r2);
        StackedXYAreaRenderer2Tests.assertEquals((Object)r2, (Object)r1);
    }

    public void testHashcode() {
        StackedXYAreaRenderer2 r1 = new StackedXYAreaRenderer2();
        StackedXYAreaRenderer2 r2 = new StackedXYAreaRenderer2();
        StackedXYAreaRenderer2Tests.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        StackedXYAreaRenderer2Tests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        StackedXYAreaRenderer2 r1 = new StackedXYAreaRenderer2();
        StackedXYAreaRenderer2 r2 = null;
        try {
            r2 = (StackedXYAreaRenderer2)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        StackedXYAreaRenderer2Tests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        StackedXYAreaRenderer2Tests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        StackedXYAreaRenderer2Tests.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        StackedXYAreaRenderer2 r1 = new StackedXYAreaRenderer2();
        StackedXYAreaRenderer2 r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (StackedXYAreaRenderer2)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        StackedXYAreaRenderer2Tests.assertEquals((Object)r1, r2);
    }

    public void testFindRangeBounds() {
        TableXYDataset dataset = RendererXYPackageTests.createTestTableXYDataset();
        JFreeChart chart = ChartFactory.createStackedXYAreaChart("Test Chart", "X", "Y", dataset, PlotOrientation.VERTICAL, false, false, false);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setRenderer(new StackedXYAreaRenderer2());
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        Range bounds = rangeAxis.getRange();
        StackedXYAreaRenderer2Tests.assertTrue((boolean)bounds.contains(6.0));
        StackedXYAreaRenderer2Tests.assertTrue((boolean)bounds.contains(8.0));
    }
}

