/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.xy.HighLowRenderer;

public class HighLowRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(HighLowRendererTests.class);
    }

    public HighLowRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        HighLowRenderer r1 = new HighLowRenderer();
        HighLowRenderer r2 = new HighLowRenderer();
        HighLowRendererTests.assertEquals((Object)r1, (Object)r2);
    }

    public void testHashcode() {
        HighLowRenderer r1 = new HighLowRenderer();
        HighLowRenderer r2 = new HighLowRenderer();
        HighLowRendererTests.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        HighLowRendererTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        HighLowRenderer r1 = new HighLowRenderer();
        HighLowRenderer r2 = null;
        try {
            r2 = (HighLowRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        HighLowRendererTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        HighLowRendererTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        HighLowRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        HighLowRenderer r1 = new HighLowRenderer();
        HighLowRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (HighLowRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        HighLowRendererTests.assertEquals((Object)r1, r2);
    }
}

