/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.xy.ClusteredXYBarRenderer;

public class ClusteredXYBarRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(ClusteredXYBarRendererTests.class);
    }

    public ClusteredXYBarRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        ClusteredXYBarRenderer r1 = new ClusteredXYBarRenderer();
        ClusteredXYBarRenderer r2 = new ClusteredXYBarRenderer();
        ClusteredXYBarRendererTests.assertEquals((Object)r1, (Object)r2);
        ClusteredXYBarRendererTests.assertEquals((Object)r2, (Object)r1);
        r1 = new ClusteredXYBarRenderer(1.2, false);
        ClusteredXYBarRendererTests.assertFalse((boolean)r1.equals(r2));
        r2 = new ClusteredXYBarRenderer(1.2, false);
        ClusteredXYBarRendererTests.assertTrue((boolean)r1.equals(r2));
        r1 = new ClusteredXYBarRenderer(1.2, true);
        ClusteredXYBarRendererTests.assertFalse((boolean)r1.equals(r2));
        r2 = new ClusteredXYBarRenderer(1.2, true);
        ClusteredXYBarRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testHashcode() {
        ClusteredXYBarRenderer r1 = new ClusteredXYBarRenderer();
        ClusteredXYBarRenderer r2 = new ClusteredXYBarRenderer();
        ClusteredXYBarRendererTests.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        ClusteredXYBarRendererTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        ClusteredXYBarRenderer r1 = new ClusteredXYBarRenderer();
        ClusteredXYBarRenderer r2 = null;
        try {
            r2 = (ClusteredXYBarRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        ClusteredXYBarRendererTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        ClusteredXYBarRendererTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        ClusteredXYBarRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        ClusteredXYBarRenderer r1 = new ClusteredXYBarRenderer();
        ClusteredXYBarRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (ClusteredXYBarRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        ClusteredXYBarRendererTests.assertEquals((Object)r1, r2);
    }
}

