/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;

public class LineAndShapeRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(LineAndShapeRendererTests.class);
    }

    public LineAndShapeRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        LineAndShapeRenderer r1 = new LineAndShapeRenderer();
        LineAndShapeRenderer r2 = new LineAndShapeRenderer();
        LineAndShapeRendererTests.assertEquals((Object)r1, (Object)r2);
        r1.setShapesVisible(!r1.isShapesVisible());
        LineAndShapeRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setShapesVisible(r1.isShapesVisible());
        LineAndShapeRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setLinesVisible(!r1.isLinesVisible());
        LineAndShapeRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setLinesVisible(r1.isLinesVisible());
        LineAndShapeRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setShapesFilled(false);
        LineAndShapeRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setShapesFilled(false);
        LineAndShapeRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setSeriesShapesFilled(1, true);
        LineAndShapeRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setSeriesShapesFilled(1, true);
        LineAndShapeRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setDefaultShapesFilled(false);
        LineAndShapeRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setDefaultShapesFilled(false);
        LineAndShapeRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setUseOutlinePaint(true);
        LineAndShapeRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setUseOutlinePaint(true);
        LineAndShapeRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testHashcode() {
        LineAndShapeRenderer r1 = new LineAndShapeRenderer();
        LineAndShapeRenderer r2 = new LineAndShapeRenderer();
        LineAndShapeRendererTests.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        LineAndShapeRendererTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        LineAndShapeRenderer r1 = new LineAndShapeRenderer();
        LineAndShapeRenderer r2 = null;
        try {
            r2 = (LineAndShapeRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        LineAndShapeRendererTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        LineAndShapeRendererTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        LineAndShapeRendererTests.assertTrue((boolean)r1.equals(r2));
        LineAndShapeRendererTests.assertTrue((boolean)this.checkIndependence(r1, r2));
    }

    private boolean checkIndependence(LineAndShapeRenderer r1, LineAndShapeRenderer r2) {
        boolean b0 = r1.equals(r2);
        r1.setShapesVisible(!r1.isShapesVisible());
        boolean b1 = !r1.equals(r2);
        r2.setShapesVisible(r1.isShapesVisible());
        boolean b2 = r1.equals(r2);
        r1.setLinesVisible(!r1.isLinesVisible());
        boolean b3 = !r1.equals(r2);
        r2.setLinesVisible(r1.isLinesVisible());
        boolean b4 = r1.equals(r2);
        boolean flag = true;
        Boolean existing = r1.getShapesFilled();
        if (existing != null) {
            flag = existing == false;
        }
        r1.setShapesFilled(flag);
        boolean b5 = !r1.equals(r2);
        r2.setShapesFilled(flag);
        boolean b6 = r1.equals(r2);
        r1.setShapesFilled(false);
        r2.setShapesFilled(false);
        r1.setSeriesShapesFilled(0, false);
        r2.setSeriesShapesFilled(0, true);
        boolean b7 = !r1.equals(r2);
        r2.setSeriesShapesFilled(0, false);
        boolean b8 = r1.equals(r2);
        r1.setDefaultShapesFilled(false);
        r2.setDefaultShapesFilled(true);
        boolean b9 = !r1.equals(r2);
        r2.setDefaultShapesFilled(false);
        boolean b10 = r1.equals(r2);
        return b0 && b1 && b2 && b3 && b4 && b5 && b6 && b7 && b8 && b9 && b10;
    }

    public void testSerialization() {
        LineAndShapeRenderer r1 = new LineAndShapeRenderer();
        LineAndShapeRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (LineAndShapeRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        LineAndShapeRendererTests.assertEquals((Object)r1, r2);
    }
}

