/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.category.LevelRenderer;

public class LevelRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(LevelRendererTests.class);
    }

    public LevelRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        LevelRenderer r1 = new LevelRenderer();
        LevelRenderer r2 = new LevelRenderer();
        LevelRendererTests.assertTrue((boolean)r1.equals(r2));
        LevelRendererTests.assertTrue((boolean)r2.equals(r1));
        r1.setItemMargin(0.123);
        LevelRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setItemMargin(0.123);
        LevelRendererTests.assertTrue((boolean)r1.equals(r2));
        r1.setMaxItemWidth(0.234);
        LevelRendererTests.assertFalse((boolean)r1.equals(r2));
        r2.setMaxItemWidth(0.234);
        LevelRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testHashcode() {
        LevelRenderer r1 = new LevelRenderer();
        LevelRenderer r2 = new LevelRenderer();
        LevelRendererTests.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        LevelRendererTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        LevelRenderer r1 = new LevelRenderer();
        r1.setItemMargin(0.123);
        r1.setMaxItemWidth(0.234);
        LevelRenderer r2 = null;
        try {
            r2 = (LevelRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        LevelRendererTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        LevelRendererTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        LevelRendererTests.assertTrue((boolean)r1.equals(r2));
        LevelRendererTests.assertTrue((boolean)this.checkIndependence(r1, r2));
    }

    private boolean checkIndependence(LevelRenderer r1, LevelRenderer r2) {
        boolean b0 = r1.equals(r2);
        r1.setItemMargin(0.0);
        boolean b1 = !r1.equals(r2);
        r2.setItemMargin(0.0);
        boolean b2 = r1.equals(r2);
        return b0 && b1 && b2;
    }

    public void testSerialization() {
        LevelRenderer r1 = new LevelRenderer();
        LevelRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (LevelRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LevelRendererTests.assertEquals((Object)r1, r2);
    }
}

