/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.ui.LengthAdjustmentType;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;

public class ValueMarkerTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(ValueMarkerTests.class);
    }

    public ValueMarkerTests(String name) {
        super(name);
    }

    public void testEquals() {
        ValueMarker m1 = new ValueMarker(45.0);
        ValueMarker m2 = new ValueMarker(45.0);
        ValueMarkerTests.assertTrue((boolean)((Marker)m1).equals(m2));
        ValueMarkerTests.assertTrue((boolean)((Marker)m2).equals(m1));
        m1.setPaint(Color.red);
        ValueMarkerTests.assertFalse((boolean)((Marker)m1).equals(m2));
        m2.setPaint(Color.red);
        ValueMarkerTests.assertTrue((boolean)((Marker)m1).equals(m2));
        BasicStroke stroke = new BasicStroke(2.2f);
        m1.setStroke(stroke);
        ValueMarkerTests.assertFalse((boolean)((Marker)m1).equals(m2));
        m2.setStroke(stroke);
        ValueMarkerTests.assertTrue((boolean)((Marker)m1).equals(m2));
        m1.setOutlinePaint(Color.red);
        ValueMarkerTests.assertFalse((boolean)((Marker)m1).equals(m2));
        m2.setOutlinePaint(Color.red);
        ValueMarkerTests.assertTrue((boolean)((Marker)m1).equals(m2));
        m1.setOutlineStroke(stroke);
        ValueMarkerTests.assertFalse((boolean)((Marker)m1).equals(m2));
        m2.setOutlineStroke(stroke);
        ValueMarkerTests.assertTrue((boolean)((Marker)m1).equals(m2));
        m1.setAlpha(0.1f);
        ValueMarkerTests.assertFalse((boolean)((Marker)m1).equals(m2));
        m2.setAlpha(0.1f);
        ValueMarkerTests.assertTrue((boolean)((Marker)m1).equals(m2));
        m1.setLabel("New Label");
        ValueMarkerTests.assertFalse((boolean)((Marker)m1).equals(m2));
        m2.setLabel("New Label");
        ValueMarkerTests.assertTrue((boolean)((Marker)m1).equals(m2));
        m1.setLabelFont(new Font("SansSerif", 0, 10));
        ValueMarkerTests.assertFalse((boolean)((Marker)m1).equals(m2));
        m2.setLabelFont(new Font("SansSerif", 0, 10));
        ValueMarkerTests.assertTrue((boolean)((Marker)m1).equals(m2));
        m1.setLabelPaint(Color.red);
        ValueMarkerTests.assertFalse((boolean)((Marker)m1).equals(m2));
        m2.setLabelPaint(Color.red);
        ValueMarkerTests.assertTrue((boolean)((Marker)m1).equals(m2));
        m1.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
        ValueMarkerTests.assertFalse((boolean)((Marker)m1).equals(m2));
        m2.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
        ValueMarkerTests.assertTrue((boolean)((Marker)m1).equals(m2));
        m1.setLabelTextAnchor(TextAnchor.BASELINE_RIGHT);
        ValueMarkerTests.assertFalse((boolean)((Marker)m1).equals(m2));
        m2.setLabelTextAnchor(TextAnchor.BASELINE_RIGHT);
        ValueMarkerTests.assertTrue((boolean)((Marker)m1).equals(m2));
        m1.setLabelOffset(new RectangleInsets(10.0, 10.0, 10.0, 10.0));
        ValueMarkerTests.assertFalse((boolean)((Marker)m1).equals(m2));
        m2.setLabelOffset(new RectangleInsets(10.0, 10.0, 10.0, 10.0));
        ValueMarkerTests.assertTrue((boolean)((Marker)m1).equals(m2));
        m1.setLabelOffsetType(LengthAdjustmentType.EXPAND);
        ValueMarkerTests.assertFalse((boolean)((Marker)m1).equals(m2));
        m2.setLabelOffsetType(LengthAdjustmentType.EXPAND);
        ValueMarkerTests.assertTrue((boolean)((Marker)m1).equals(m2));
        m1 = new ValueMarker(12.3);
        m2 = new ValueMarker(45.6);
        ValueMarkerTests.assertFalse((boolean)((Marker)m1).equals(m2));
        m2 = new ValueMarker(12.3);
        ValueMarkerTests.assertTrue((boolean)((Marker)m1).equals(m2));
    }

    public void testCloning() {
        ValueMarker m1 = new ValueMarker(25.0);
        ValueMarker m2 = null;
        try {
            m2 = (ValueMarker)m1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        ValueMarkerTests.assertTrue((m1 != m2 ? 1 : 0) != 0);
        ValueMarkerTests.assertTrue((m1.getClass() == m2.getClass() ? 1 : 0) != 0);
        ValueMarkerTests.assertTrue((boolean)m1.equals(m2));
    }

    public void testSerialization() {
        ValueMarker m1 = new ValueMarker(25.0);
        ValueMarker m2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(m1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            m2 = (ValueMarker)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        boolean b = m1.equals(m2);
        ValueMarkerTests.assertTrue((boolean)b);
    }
}

