/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.urls.StandardPieURLGenerator;
import org.jfree.util.Rotation;

public class PiePlotTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(PiePlotTests.class);
    }

    public PiePlotTests(String name) {
        super(name);
    }

    public void testEquals() {
        PiePlot plot1 = new PiePlot();
        PiePlot plot2 = new PiePlot();
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        PiePlotTests.assertTrue((boolean)plot2.equals(plot1));
        plot1.setPieIndex(99);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setPieIndex(99);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setInteriorGap(0.15);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setInteriorGap(0.15);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setCircular(!plot1.isCircular());
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setCircular(false);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setStartAngle(Math.PI);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setStartAngle(Math.PI);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDirection(Rotation.ANTICLOCKWISE);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDirection(Rotation.ANTICLOCKWISE);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setIgnoreZeroValues(true);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setIgnoreZeroValues(true);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setIgnoreNullValues(true);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setIgnoreNullValues(true);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setSectionPaint(Color.red);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setSectionPaint(Color.red);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setSectionPaint(2, Color.red);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setSectionPaint(2, Color.red);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setBaseSectionPaint(Color.red);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setBaseSectionPaint(Color.red);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setSectionOutlinePaint(Color.red);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setSectionOutlinePaint(Color.red);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setSectionOutlinePaint(2, Color.red);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setSectionOutlinePaint(2, Color.red);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setBaseSectionOutlinePaint(Color.red);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setBaseSectionOutlinePaint(Color.red);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setSectionOutlineStroke(new BasicStroke(1.0f));
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setSectionOutlineStroke(new BasicStroke(1.0f));
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setSectionOutlineStroke(2, new BasicStroke(1.0f));
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setSectionOutlineStroke(2, new BasicStroke(1.0f));
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setBaseSectionOutlineStroke(new BasicStroke(1.0f));
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setBaseSectionOutlineStroke(new BasicStroke(1.0f));
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setShadowPaint(Color.red);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setShadowPaint(Color.red);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setShadowXOffset(4.4);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setShadowXOffset(4.4);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setShadowYOffset(4.4);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setShadowYOffset(4.4);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLabelFont(new Font("Serif", 0, 18));
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelFont(new Font("Serif", 0, 18));
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLabelPaint(Color.red);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelPaint(Color.red);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLabelBackgroundPaint(Color.red);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelBackgroundPaint(Color.red);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLabelOutlinePaint(Color.red);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelOutlinePaint(Color.red);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        BasicStroke s = new BasicStroke(1.1f);
        plot1.setLabelOutlineStroke(s);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelOutlineStroke(s);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLabelShadowPaint(Color.red);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelShadowPaint(Color.red);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setExplodePercent(3, 0.33);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setExplodePercent(3, 0.33);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLabelGenerator(new StandardPieItemLabelGenerator("{2}{1}{0}"));
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelGenerator(new StandardPieItemLabelGenerator("{2}{1}{0}"));
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        Font f = new Font("SansSerif", 0, 20);
        plot1.setLabelFont(f);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelFont(f);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLabelPaint(Color.blue);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelPaint(Color.blue);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setMaximumLabelWidth(0.33);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setMaximumLabelWidth(0.33);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLabelGap(0.11);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelGap(0.11);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLabelLinksVisible(false);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelLinksVisible(false);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLabelLinkMargin(0.11);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelLinkMargin(0.11);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLabelLinkPaint(Color.red);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelLinkPaint(Color.red);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLabelLinkStroke(new BasicStroke(1.0f));
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLabelLinkStroke(new BasicStroke(1.0f));
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setToolTipGenerator(new StandardPieItemLabelGenerator("{2}{1}{0}"));
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setToolTipGenerator(new StandardPieItemLabelGenerator("{2}{1}{0}"));
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setURLGenerator(new StandardPieURLGenerator("xx"));
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setURLGenerator(new StandardPieURLGenerator("xx"));
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setMinimumArcAngleToDraw(1.0);
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setMinimumArcAngleToDraw(1.0);
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setLegendItemShape(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0));
        PiePlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setLegendItemShape(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0));
        PiePlotTests.assertTrue((boolean)plot1.equals(plot2));
    }

    public void testCloning() {
        PiePlot p1 = new PiePlot();
        PiePlot p2 = null;
        try {
            p2 = (PiePlot)p1.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            System.err.println("Failed to clone.");
        }
        PiePlotTests.assertTrue((p1 != p2 ? 1 : 0) != 0);
        PiePlotTests.assertTrue((p1.getClass() == p2.getClass() ? 1 : 0) != 0);
        PiePlotTests.assertTrue((boolean)p1.equals(p2));
    }

    public void testSerialization() {
        PiePlot p1 = new PiePlot(null);
        PiePlot p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(p1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            p2 = (PiePlot)in.readObject();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PiePlotTests.assertEquals((Object)p1, p2);
    }
}

