/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.StandardGradientPaintTransformer;

public class IntervalMarkerTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(IntervalMarkerTests.class);
    }

    public IntervalMarkerTests(String name) {
        super(name);
    }

    public void testEquals() {
        IntervalMarker m1 = new IntervalMarker(45.0, 50.0);
        IntervalMarker m2 = new IntervalMarker(45.0, 50.0);
        IntervalMarkerTests.assertTrue((boolean)m1.equals(m2));
        IntervalMarkerTests.assertTrue((boolean)m2.equals(m1));
        m1 = new IntervalMarker(44.0, 50.0);
        IntervalMarkerTests.assertFalse((boolean)m1.equals(m2));
        m2 = new IntervalMarker(44.0, 50.0);
        IntervalMarkerTests.assertTrue((boolean)m1.equals(m2));
        m1 = new IntervalMarker(44.0, 55.0);
        IntervalMarkerTests.assertFalse((boolean)m1.equals(m2));
        m2 = new IntervalMarker(44.0, 55.0);
        IntervalMarkerTests.assertTrue((boolean)m1.equals(m2));
        StandardGradientPaintTransformer t = new StandardGradientPaintTransformer(GradientPaintTransformType.HORIZONTAL);
        m1.setGradientPaintTransformer((GradientPaintTransformer)t);
        IntervalMarkerTests.assertFalse((boolean)m1.equals(m2));
        m2.setGradientPaintTransformer((GradientPaintTransformer)t);
        IntervalMarkerTests.assertTrue((boolean)m1.equals(m2));
    }

    public void testCloning() {
        IntervalMarker m1 = new IntervalMarker(45.0, 50.0);
        IntervalMarker m2 = null;
        try {
            m2 = (IntervalMarker)m1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        IntervalMarkerTests.assertTrue((m1 != m2 ? 1 : 0) != 0);
        IntervalMarkerTests.assertTrue((m1.getClass() == m2.getClass() ? 1 : 0) != 0);
        IntervalMarkerTests.assertTrue((boolean)m1.equals(m2));
    }

    public void testSerialization() {
        IntervalMarker m1 = new IntervalMarker(45.0, 50.0);
        IntervalMarker m2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(m1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            m2 = (IntervalMarker)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        boolean b = m1.equals(m2);
        IntervalMarkerTests.assertTrue((boolean)b);
    }
}

