/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.plot.DefaultDrawingSupplier;

public class DefaultDrawingSupplierTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(DefaultDrawingSupplierTests.class);
    }

    public DefaultDrawingSupplierTests(String name) {
        super(name);
    }

    public void testEquals() {
        DefaultDrawingSupplier r1 = new DefaultDrawingSupplier();
        DefaultDrawingSupplier r2 = new DefaultDrawingSupplier();
        DefaultDrawingSupplierTests.assertTrue((boolean)r1.equals(r2));
        DefaultDrawingSupplierTests.assertTrue((boolean)r2.equals(r1));
        Paint[] ps1A = new Paint[]{Color.red, Color.blue};
        Paint[] ps2A = new Paint[]{Color.green, Color.yellow, Color.white};
        Paint[] ops1A = new Paint[]{Color.lightGray, Color.blue};
        Paint[] ops2A = new Paint[]{Color.black, Color.yellow, Color.cyan};
        Stroke[] ss1A = new Stroke[]{new BasicStroke(1.1f)};
        Stroke[] ss2A = new Stroke[]{new BasicStroke(2.2f), new BasicStroke(3.3f)};
        Stroke[] oss1A = new Stroke[]{new BasicStroke(4.4f)};
        Stroke[] oss2A = new Stroke[]{new BasicStroke(5.5f), new BasicStroke(6.6f)};
        Shape[] shapes1A = new Shape[]{new Rectangle2D.Double(1.0, 1.0, 1.0, 1.0)};
        Shape[] shapes2A = new Shape[]{new Rectangle2D.Double(2.0, 2.0, 2.0, 2.0), new Rectangle2D.Double(2.0, 2.0, 2.0, 2.0)};
        Paint[] ps1B = new Paint[]{Color.red, Color.blue};
        Paint[] ps2B = new Paint[]{Color.green, Color.yellow, Color.white};
        Paint[] ops1B = new Paint[]{Color.lightGray, Color.blue};
        Paint[] ops2B = new Paint[]{Color.black, Color.yellow, Color.cyan};
        Stroke[] ss1B = new Stroke[]{new BasicStroke(1.1f)};
        Stroke[] ss2B = new Stroke[]{new BasicStroke(2.2f), new BasicStroke(3.3f)};
        Stroke[] oss1B = new Stroke[]{new BasicStroke(4.4f)};
        Stroke[] oss2B = new Stroke[]{new BasicStroke(5.5f), new BasicStroke(6.6f)};
        Shape[] shapes1B = new Shape[]{new Rectangle2D.Double(1.0, 1.0, 1.0, 1.0)};
        Shape[] shapes2B = new Shape[]{new Rectangle2D.Double(2.0, 2.0, 2.0, 2.0), new Rectangle2D.Double(2.0, 2.0, 2.0, 2.0)};
        r1 = new DefaultDrawingSupplier(ps1A, ops1A, ss1A, oss1A, shapes1A);
        r2 = new DefaultDrawingSupplier(ps1B, ops1B, ss1B, oss1B, shapes1B);
        DefaultDrawingSupplierTests.assertTrue((boolean)r1.equals(r2));
        r1 = new DefaultDrawingSupplier(ps2A, ops1A, ss1A, oss1A, shapes1A);
        DefaultDrawingSupplierTests.assertFalse((boolean)r1.equals(r2));
        r2 = new DefaultDrawingSupplier(ps2B, ops1B, ss1B, oss1B, shapes1B);
        DefaultDrawingSupplierTests.assertTrue((boolean)r1.equals(r2));
        r1 = new DefaultDrawingSupplier(ps2A, ops2A, ss1A, oss1A, shapes1A);
        DefaultDrawingSupplierTests.assertFalse((boolean)r1.equals(r2));
        r2 = new DefaultDrawingSupplier(ps2B, ops2B, ss1B, oss1B, shapes1B);
        DefaultDrawingSupplierTests.assertTrue((boolean)r1.equals(r2));
        r1 = new DefaultDrawingSupplier(ps2A, ops2A, ss2A, oss1A, shapes1A);
        DefaultDrawingSupplierTests.assertFalse((boolean)r1.equals(r2));
        r2 = new DefaultDrawingSupplier(ps2B, ops2B, ss2B, oss1B, shapes1B);
        DefaultDrawingSupplierTests.assertTrue((boolean)r1.equals(r2));
        r1 = new DefaultDrawingSupplier(ps2A, ops2A, ss2A, oss2A, shapes1A);
        DefaultDrawingSupplierTests.assertFalse((boolean)r1.equals(r2));
        r2 = new DefaultDrawingSupplier(ps2B, ops2B, ss2B, oss2B, shapes1B);
        DefaultDrawingSupplierTests.assertTrue((boolean)r1.equals(r2));
        r1 = new DefaultDrawingSupplier(ps2A, ops2A, ss2A, oss2A, shapes2A);
        DefaultDrawingSupplierTests.assertFalse((boolean)r1.equals(r2));
        r2 = new DefaultDrawingSupplier(ps2B, ops2B, ss2B, oss2B, shapes2B);
        DefaultDrawingSupplierTests.assertTrue((boolean)r1.equals(r2));
        r1.getNextPaint();
        DefaultDrawingSupplierTests.assertFalse((boolean)r1.equals(r2));
        r2.getNextPaint();
        DefaultDrawingSupplierTests.assertTrue((boolean)r1.equals(r2));
        r1.getNextOutlinePaint();
        DefaultDrawingSupplierTests.assertFalse((boolean)r1.equals(r2));
        r2.getNextOutlinePaint();
        DefaultDrawingSupplierTests.assertTrue((boolean)r1.equals(r2));
        r1.getNextStroke();
        DefaultDrawingSupplierTests.assertFalse((boolean)r1.equals(r2));
        r2.getNextStroke();
        DefaultDrawingSupplierTests.assertTrue((boolean)r1.equals(r2));
        r1.getNextOutlineStroke();
        DefaultDrawingSupplierTests.assertFalse((boolean)r1.equals(r2));
        r2.getNextOutlineStroke();
        DefaultDrawingSupplierTests.assertTrue((boolean)r1.equals(r2));
        r1.getNextShape();
        DefaultDrawingSupplierTests.assertFalse((boolean)r1.equals(r2));
        r2.getNextShape();
        DefaultDrawingSupplierTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testCloning() {
        DefaultDrawingSupplier r1 = new DefaultDrawingSupplier();
        DefaultDrawingSupplier r2 = null;
        try {
            r2 = (DefaultDrawingSupplier)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            System.err.println("Failed to clone.");
        }
        DefaultDrawingSupplierTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        DefaultDrawingSupplierTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        DefaultDrawingSupplierTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        DefaultDrawingSupplier r1 = new DefaultDrawingSupplier();
        DefaultDrawingSupplier r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (DefaultDrawingSupplier)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        DefaultDrawingSupplierTests.assertEquals((Object)r1, r2);
    }
}

