/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.data.category.DefaultCategoryDataset;

public class StandardCategoryItemLabelGeneratorTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(StandardCategoryItemLabelGeneratorTests.class);
    }

    public StandardCategoryItemLabelGeneratorTests(String name) {
        super(name);
    }

    public void testGenerateLabel() {
        StandardCategoryItemLabelGenerator g = new StandardCategoryItemLabelGenerator("{2}", new DecimalFormat("0.000"));
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(1.0, (Comparable)((Object)"R0"), (Comparable)((Object)"C0"));
        dataset.addValue(2.0, (Comparable)((Object)"R0"), (Comparable)((Object)"C1"));
        dataset.addValue(3.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C0"));
        dataset.addValue(null, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        String s = g.generateLabel(dataset, 0, 0);
        StandardCategoryItemLabelGeneratorTests.assertEquals((String)"1.000", (String)s);
        s = g.generateLabel(dataset, 1, 1);
        StandardCategoryItemLabelGeneratorTests.assertEquals((String)"-", (String)s);
    }

    public void testEquals() {
        StandardCategoryItemLabelGenerator g1 = new StandardCategoryItemLabelGenerator();
        StandardCategoryItemLabelGenerator g2 = new StandardCategoryItemLabelGenerator();
        StandardCategoryItemLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
        StandardCategoryItemLabelGeneratorTests.assertTrue((boolean)g2.equals(g1));
        g1 = new StandardCategoryItemLabelGenerator("{0}", new DecimalFormat("0.000"));
        StandardCategoryItemLabelGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardCategoryItemLabelGenerator("{0}", new DecimalFormat("0.000"));
        StandardCategoryItemLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new StandardCategoryItemLabelGenerator("{1}", new DecimalFormat("0.000"));
        StandardCategoryItemLabelGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardCategoryItemLabelGenerator("{1}", new DecimalFormat("0.000"));
        StandardCategoryItemLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new StandardCategoryItemLabelGenerator("{2}", new SimpleDateFormat("d-MMM"));
        StandardCategoryItemLabelGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardCategoryItemLabelGenerator("{2}", new SimpleDateFormat("d-MMM"));
        StandardCategoryItemLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
    }

    public void testCloning() {
        StandardCategoryItemLabelGenerator g1 = new StandardCategoryItemLabelGenerator();
        StandardCategoryItemLabelGenerator g2 = null;
        try {
            g2 = (StandardCategoryItemLabelGenerator)g1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        StandardCategoryItemLabelGeneratorTests.assertTrue((g1 != g2 ? 1 : 0) != 0);
        StandardCategoryItemLabelGeneratorTests.assertTrue((g1.getClass() == g2.getClass() ? 1 : 0) != 0);
        StandardCategoryItemLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
    }

    public void testSerialization() {
        StandardCategoryItemLabelGenerator g1 = new StandardCategoryItemLabelGenerator("{2}", DateFormat.getInstance());
        StandardCategoryItemLabelGenerator g2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(g1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            g2 = (StandardCategoryItemLabelGenerator)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        StandardCategoryItemLabelGeneratorTests.assertEquals((Object)g1, g2);
    }
}

