/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.labels.BoxAndWhiskerXYToolTipGenerator;

public class BoxAndWhiskerXYToolTipGeneratorTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(BoxAndWhiskerXYToolTipGeneratorTests.class);
    }

    public BoxAndWhiskerXYToolTipGeneratorTests(String name) {
        super(name);
    }

    public void testEquals() {
        BoxAndWhiskerXYToolTipGenerator g1 = new BoxAndWhiskerXYToolTipGenerator();
        BoxAndWhiskerXYToolTipGenerator g2 = new BoxAndWhiskerXYToolTipGenerator();
        BoxAndWhiskerXYToolTipGeneratorTests.assertTrue((boolean)g1.equals(g2));
        BoxAndWhiskerXYToolTipGeneratorTests.assertTrue((boolean)g2.equals(g1));
        g1 = new BoxAndWhiskerXYToolTipGenerator("{0} --> {1} {2}", (DateFormat)new SimpleDateFormat("yyyy"), (NumberFormat)new DecimalFormat("0.0"));
        g2 = new BoxAndWhiskerXYToolTipGenerator("{1} {2}", (DateFormat)new SimpleDateFormat("yyyy"), (NumberFormat)new DecimalFormat("0.0"));
        BoxAndWhiskerXYToolTipGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new BoxAndWhiskerXYToolTipGenerator("{0} --> {1} {2}", (DateFormat)new SimpleDateFormat("yyyy"), (NumberFormat)new DecimalFormat("0.0"));
        BoxAndWhiskerXYToolTipGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new BoxAndWhiskerXYToolTipGenerator("{0} --> {1} {2}", (DateFormat)new SimpleDateFormat("yyyy"), (NumberFormat)new DecimalFormat("0.0"));
        g2 = new BoxAndWhiskerXYToolTipGenerator("{0} --> {1} {2}", (DateFormat)new SimpleDateFormat("MMM-yyyy"), (NumberFormat)new DecimalFormat("0.0"));
        BoxAndWhiskerXYToolTipGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new BoxAndWhiskerXYToolTipGenerator("{0} --> {1} {2}", (DateFormat)new SimpleDateFormat("yyyy"), (NumberFormat)new DecimalFormat("0.0"));
        BoxAndWhiskerXYToolTipGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new BoxAndWhiskerXYToolTipGenerator("{0} --> {1} {2}", (DateFormat)new SimpleDateFormat("yyyy"), (NumberFormat)new DecimalFormat("0.0"));
        g2 = new BoxAndWhiskerXYToolTipGenerator("{0} --> {1} {2}", (DateFormat)new SimpleDateFormat("yyyy"), (NumberFormat)new DecimalFormat("0.00"));
        BoxAndWhiskerXYToolTipGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new BoxAndWhiskerXYToolTipGenerator("{0} --> {1} {2}", (DateFormat)new SimpleDateFormat("yyyy"), (NumberFormat)new DecimalFormat("0.0"));
        BoxAndWhiskerXYToolTipGeneratorTests.assertTrue((boolean)g1.equals(g2));
    }

    public void testCloning() {
        BoxAndWhiskerXYToolTipGenerator g1 = new BoxAndWhiskerXYToolTipGenerator();
        BoxAndWhiskerXYToolTipGenerator g2 = null;
        try {
            g2 = (BoxAndWhiskerXYToolTipGenerator)g1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        BoxAndWhiskerXYToolTipGeneratorTests.assertTrue((g1 != g2 ? 1 : 0) != 0);
        BoxAndWhiskerXYToolTipGeneratorTests.assertTrue((g1.getClass() == g2.getClass() ? 1 : 0) != 0);
        BoxAndWhiskerXYToolTipGeneratorTests.assertTrue((boolean)g1.equals(g2));
    }

    public void testSerialization() {
        BoxAndWhiskerXYToolTipGenerator g1 = new BoxAndWhiskerXYToolTipGenerator();
        BoxAndWhiskerXYToolTipGenerator g2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(g1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            g2 = (BoxAndWhiskerXYToolTipGenerator)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        BoxAndWhiskerXYToolTipGeneratorTests.assertEquals((Object)g1, g2);
    }
}

