/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.junit;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.StandardCategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;

public class WaterfallChartTests
extends TestCase {
    private JFreeChart chart;

    public static Test suite() {
        return new TestSuite(WaterfallChartTests.class);
    }

    public WaterfallChartTests(String name) {
        super(name);
    }

    protected void setUp() {
        this.chart = WaterfallChartTests.createWaterfallChart();
    }

    public void testDrawWithNullInfo() {
        boolean success = false;
        try {
            BufferedImage image = new BufferedImage(200, 100, 1);
            Graphics2D g2 = image.createGraphics();
            this.chart.draw(g2, new Rectangle2D.Double(0.0, 0.0, 200.0, 100.0), null, null);
            g2.dispose();
            success = true;
        }
        catch (Exception e) {
            success = false;
        }
        WaterfallChartTests.assertTrue((boolean)success);
    }

    public void testSetSeriesToolTipGenerator() {
        CategoryPlot plot = (CategoryPlot)this.chart.getPlot();
        CategoryItemRenderer renderer = plot.getRenderer();
        StandardCategoryToolTipGenerator tt = new StandardCategoryToolTipGenerator();
        renderer.setSeriesToolTipGenerator(0, tt);
        CategoryToolTipGenerator tt2 = renderer.getToolTipGenerator(0, 0);
        WaterfallChartTests.assertTrue((tt2 == tt ? 1 : 0) != 0);
    }

    public void testSetSeriesURLGenerator() {
        CategoryPlot plot = (CategoryPlot)this.chart.getPlot();
        CategoryItemRenderer renderer = plot.getRenderer();
        StandardCategoryURLGenerator url1 = new StandardCategoryURLGenerator();
        renderer.setSeriesItemURLGenerator(0, url1);
        CategoryURLGenerator url2 = renderer.getItemURLGenerator(0, 0);
        WaterfallChartTests.assertTrue((url2 == url1 ? 1 : 0) != 0);
    }

    private static JFreeChart createWaterfallChart() {
        Number[][] data = new Integer[][]{{new Integer(-3), new Integer(-2)}, {new Integer(-1), new Integer(1)}, {new Integer(2), new Integer(3)}};
        CategoryDataset dataset = DatasetUtilities.createCategoryDataset("S", "C", data);
        return ChartFactory.createWaterfallChart("Waterfall Chart", "Domain", "Range", dataset, PlotOrientation.HORIZONTAL, true, true, true);
    }

    static class LocalListener
    implements ChartChangeListener {
        private boolean flag = false;

        LocalListener() {
        }

        public void chartChanged(ChartChangeEvent event) {
            this.flag = true;
        }
    }
}

