/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.junit;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Calendar;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.StandardCategoryURLGenerator;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.time.SimpleTimePeriod;

public class GanttChartTests
extends TestCase {
    private JFreeChart chart;

    public static Test suite() {
        return new TestSuite(GanttChartTests.class);
    }

    public GanttChartTests(String name) {
        super(name);
    }

    protected void setUp() {
        this.chart = GanttChartTests.createGanttChart();
    }

    public void testDrawWithNullInfo() {
        boolean success = false;
        try {
            BufferedImage image = new BufferedImage(200, 100, 1);
            Graphics2D g2 = image.createGraphics();
            this.chart.draw(g2, new Rectangle2D.Double(0.0, 0.0, 200.0, 100.0), null, null);
            g2.dispose();
            success = true;
        }
        catch (Exception e) {
            success = false;
        }
        GanttChartTests.assertTrue((boolean)success);
    }

    public void testReplaceDataset() {
        LocalListener l = new LocalListener();
        this.chart.addChangeListener(l);
        this.chart.getCategoryPlot().setDataset(null);
        GanttChartTests.assertEquals((boolean)true, (boolean)l.flag);
    }

    public void testSetSeriesToolTipGenerator() {
        CategoryPlot plot = (CategoryPlot)this.chart.getPlot();
        CategoryItemRenderer renderer = plot.getRenderer();
        StandardCategoryToolTipGenerator tt = new StandardCategoryToolTipGenerator();
        renderer.setSeriesToolTipGenerator(0, tt);
        CategoryToolTipGenerator tt2 = renderer.getToolTipGenerator(0, 0);
        GanttChartTests.assertTrue((tt2 == tt ? 1 : 0) != 0);
    }

    public void testSetSeriesURLGenerator() {
        CategoryPlot plot = (CategoryPlot)this.chart.getPlot();
        CategoryItemRenderer renderer = plot.getRenderer();
        StandardCategoryURLGenerator url1 = new StandardCategoryURLGenerator();
        renderer.setSeriesItemURLGenerator(0, url1);
        CategoryURLGenerator url2 = renderer.getItemURLGenerator(0, 0);
        GanttChartTests.assertTrue((url2 == url1 ? 1 : 0) != 0);
    }

    private static JFreeChart createGanttChart() {
        return ChartFactory.createGanttChart("Gantt Chart", "Domain", "Range", null, true, true, true);
    }

    public static IntervalCategoryDataset createDataset() {
        TaskSeries s1 = new TaskSeries("Scheduled");
        s1.add(new Task("Write Proposal", new SimpleTimePeriod(GanttChartTests.date(1, 3, 2001), GanttChartTests.date(5, 3, 2001))));
        s1.add(new Task("Obtain Approval", new SimpleTimePeriod(GanttChartTests.date(9, 3, 2001), GanttChartTests.date(9, 3, 2001))));
        s1.add(new Task("Requirements Analysis", new SimpleTimePeriod(GanttChartTests.date(10, 3, 2001), GanttChartTests.date(5, 4, 2001))));
        s1.add(new Task("Design Phase", new SimpleTimePeriod(GanttChartTests.date(6, 4, 2001), GanttChartTests.date(30, 4, 2001))));
        s1.add(new Task("Design Signoff", new SimpleTimePeriod(GanttChartTests.date(2, 5, 2001), GanttChartTests.date(2, 5, 2001))));
        s1.add(new Task("Alpha Implementation", new SimpleTimePeriod(GanttChartTests.date(3, 5, 2001), GanttChartTests.date(31, 6, 2001))));
        s1.add(new Task("Design Review", new SimpleTimePeriod(GanttChartTests.date(1, 7, 2001), GanttChartTests.date(8, 7, 2001))));
        s1.add(new Task("Revised Design Signoff", new SimpleTimePeriod(GanttChartTests.date(10, 7, 2001), GanttChartTests.date(10, 7, 2001))));
        s1.add(new Task("Beta Implementation", new SimpleTimePeriod(GanttChartTests.date(12, 7, 2001), GanttChartTests.date(12, 8, 2001))));
        s1.add(new Task("Testing", new SimpleTimePeriod(GanttChartTests.date(13, 8, 2001), GanttChartTests.date(31, 9, 2001))));
        s1.add(new Task("Final Implementation", new SimpleTimePeriod(GanttChartTests.date(1, 10, 2001), GanttChartTests.date(15, 10, 2001))));
        s1.add(new Task("Signoff", new SimpleTimePeriod(GanttChartTests.date(28, 10, 2001), GanttChartTests.date(30, 10, 2001))));
        TaskSeries s2 = new TaskSeries("Actual");
        s2.add(new Task("Write Proposal", new SimpleTimePeriod(GanttChartTests.date(1, 3, 2001), GanttChartTests.date(5, 3, 2001))));
        s2.add(new Task("Obtain Approval", new SimpleTimePeriod(GanttChartTests.date(9, 3, 2001), GanttChartTests.date(9, 3, 2001))));
        s2.add(new Task("Requirements Analysis", new SimpleTimePeriod(GanttChartTests.date(10, 3, 2001), GanttChartTests.date(15, 4, 2001))));
        s2.add(new Task("Design Phase", new SimpleTimePeriod(GanttChartTests.date(15, 4, 2001), GanttChartTests.date(17, 5, 2001))));
        s2.add(new Task("Design Signoff", new SimpleTimePeriod(GanttChartTests.date(30, 5, 2001), GanttChartTests.date(30, 5, 2001))));
        s2.add(new Task("Alpha Implementation", new SimpleTimePeriod(GanttChartTests.date(1, 6, 2001), GanttChartTests.date(12, 8, 2001))));
        s2.add(new Task("Design Review", new SimpleTimePeriod(GanttChartTests.date(12, 8, 2001), GanttChartTests.date(22, 8, 2001))));
        s2.add(new Task("Revised Design Signoff", new SimpleTimePeriod(GanttChartTests.date(25, 8, 2001), GanttChartTests.date(27, 8, 2001))));
        s2.add(new Task("Beta Implementation", new SimpleTimePeriod(GanttChartTests.date(27, 8, 2001), GanttChartTests.date(30, 9, 2001))));
        s2.add(new Task("Testing", new SimpleTimePeriod(GanttChartTests.date(31, 9, 2001), GanttChartTests.date(17, 10, 2001))));
        s2.add(new Task("Final Implementation", new SimpleTimePeriod(GanttChartTests.date(18, 10, 2001), GanttChartTests.date(5, 11, 2001))));
        s2.add(new Task("Signoff", new SimpleTimePeriod(GanttChartTests.date(10, 11, 2001), GanttChartTests.date(11, 11, 2001))));
        TaskSeriesCollection collection = new TaskSeriesCollection();
        collection.add(s1);
        collection.add(s2);
        return collection;
    }

    private static Date date(int day, int month, int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day);
        Date result = calendar.getTime();
        return result;
    }

    static class LocalListener
    implements ChartChangeListener {
        private boolean flag = false;

        LocalListener() {
        }

        public void chartChanged(ChartChangeEvent event) {
            this.flag = true;
        }
    }
}

