/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block.junit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.block.LengthConstraintType;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.data.Range;
import org.jfree.ui.Size2D;

public class RectangleConstraintTests
extends TestCase {
    private static final double EPSILON = 1.0E-10;

    public static Test suite() {
        return new TestSuite(RectangleConstraintTests.class);
    }

    public RectangleConstraintTests(String name) {
        super(name);
    }

    public void testCalculateConstrainedSize() {
        RectangleConstraint c1 = RectangleConstraint.NONE;
        Size2D s = c1.calculateConstrainedSize(new Size2D(1.2, 3.4));
        RectangleConstraintTests.assertEquals((double)s.width, (double)1.2, (double)1.0E-10);
        RectangleConstraintTests.assertEquals((double)s.height, (double)3.4, (double)1.0E-10);
        RectangleConstraint c2 = new RectangleConstraint(0.0, new Range(0.0, 0.0), LengthConstraintType.NONE, 0.0, new Range(2.0, 3.0), LengthConstraintType.RANGE);
        s = c2.calculateConstrainedSize(new Size2D(1.2, 3.4));
        RectangleConstraintTests.assertEquals((double)s.width, (double)1.2, (double)1.0E-10);
        RectangleConstraintTests.assertEquals((double)s.height, (double)3.0, (double)1.0E-10);
        RectangleConstraint c3 = new RectangleConstraint(0.0, null, LengthConstraintType.NONE, 9.9, null, LengthConstraintType.FIXED);
        s = c3.calculateConstrainedSize(new Size2D(1.2, 3.4));
        RectangleConstraintTests.assertEquals((double)s.width, (double)1.2, (double)1.0E-10);
        RectangleConstraintTests.assertEquals((double)s.height, (double)9.9, (double)1.0E-10);
        RectangleConstraint c4 = new RectangleConstraint(0.0, new Range(2.0, 3.0), LengthConstraintType.RANGE, 0.0, new Range(0.0, 0.0), LengthConstraintType.NONE);
        s = c4.calculateConstrainedSize(new Size2D(1.2, 3.4));
        RectangleConstraintTests.assertEquals((double)s.width, (double)2.0, (double)1.0E-10);
        RectangleConstraintTests.assertEquals((double)s.height, (double)3.4, (double)1.0E-10);
        RectangleConstraint c5 = new RectangleConstraint(0.0, new Range(2.0, 3.0), LengthConstraintType.RANGE, 0.0, new Range(2.0, 3.0), LengthConstraintType.RANGE);
        s = c5.calculateConstrainedSize(new Size2D(1.2, 3.4));
        RectangleConstraintTests.assertEquals((double)s.width, (double)2.0, (double)1.0E-10);
        RectangleConstraintTests.assertEquals((double)s.height, (double)3.0, (double)1.0E-10);
        RectangleConstraint c6 = new RectangleConstraint(0.0, null, LengthConstraintType.NONE, 9.9, null, LengthConstraintType.FIXED);
        s = c6.calculateConstrainedSize(new Size2D(1.2, 3.4));
        RectangleConstraintTests.assertEquals((double)s.width, (double)1.2, (double)1.0E-10);
        RectangleConstraintTests.assertEquals((double)s.height, (double)9.9, (double)1.0E-10);
        RectangleConstraint c7 = RectangleConstraint.NONE;
        s = c7.calculateConstrainedSize(new Size2D(1.2, 3.4));
        RectangleConstraintTests.assertEquals((double)s.width, (double)1.2, (double)1.0E-10);
        RectangleConstraintTests.assertEquals((double)s.height, (double)3.4, (double)1.0E-10);
        RectangleConstraint c8 = new RectangleConstraint(0.0, new Range(0.0, 0.0), LengthConstraintType.NONE, 0.0, new Range(2.0, 3.0), LengthConstraintType.RANGE);
        s = c8.calculateConstrainedSize(new Size2D(1.2, 3.4));
        RectangleConstraintTests.assertEquals((double)s.width, (double)1.2, (double)1.0E-10);
        RectangleConstraintTests.assertEquals((double)s.height, (double)3.0, (double)1.0E-10);
        RectangleConstraint c9 = new RectangleConstraint(0.0, null, LengthConstraintType.NONE, 9.9, null, LengthConstraintType.FIXED);
        s = c9.calculateConstrainedSize(new Size2D(1.2, 3.4));
        RectangleConstraintTests.assertEquals((double)s.width, (double)1.2, (double)1.0E-10);
        RectangleConstraintTests.assertEquals((double)s.height, (double)9.9, (double)1.0E-10);
    }
}

