/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.EmptyBlock;
import org.jfree.chart.block.GridArrangement;
import org.jfree.chart.block.LengthConstraintType;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.ui.Size2D;

public class GridArrangementTests
extends TestCase {
    private static final double EPSILON = 1.0E-9;

    public static Test suite() {
        return new TestSuite(GridArrangementTests.class);
    }

    public GridArrangementTests(String name) {
        super(name);
    }

    public void testEquals() {
        GridArrangement f1 = new GridArrangement(11, 22);
        GridArrangement f2 = new GridArrangement(11, 22);
        GridArrangementTests.assertTrue((boolean)f1.equals(f2));
        GridArrangementTests.assertTrue((boolean)f2.equals(f1));
        f1 = new GridArrangement(33, 22);
        GridArrangementTests.assertFalse((boolean)f1.equals(f2));
        f2 = new GridArrangement(33, 22);
        GridArrangementTests.assertTrue((boolean)f1.equals(f2));
        f1 = new GridArrangement(33, 44);
        GridArrangementTests.assertFalse((boolean)f1.equals(f2));
        f2 = new GridArrangement(33, 44);
        GridArrangementTests.assertTrue((boolean)f1.equals(f2));
    }

    public void testCloning() {
        GridArrangement f1 = new GridArrangement(1, 2);
        GridArrangementTests.assertFalse((boolean)(f1 instanceof Cloneable));
    }

    public void testSerialization() {
        GridArrangement f1 = new GridArrangement(33, 44);
        GridArrangement f2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(f1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            f2 = (GridArrangement)in.readObject();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GridArrangementTests.assertEquals((Object)f1, f2);
    }

    public void testNN() {
        BlockContainer c = this.createTestContainer1();
        Size2D s = c.arrange(null, RectangleConstraint.NONE);
        GridArrangementTests.assertEquals((double)90.0, (double)s.width, (double)1.0E-9);
        GridArrangementTests.assertEquals((double)33.0, (double)s.height, (double)1.0E-9);
    }

    public void testFN() {
        BlockContainer c = this.createTestContainer1();
        RectangleConstraint constraint = new RectangleConstraint(100.0, null, LengthConstraintType.FIXED, 0.0, null, LengthConstraintType.NONE);
        Size2D s = c.arrange(null, constraint);
        GridArrangementTests.assertEquals((double)100.0, (double)s.width, (double)1.0E-9);
        GridArrangementTests.assertEquals((double)33.0, (double)s.height, (double)1.0E-9);
    }

    private BlockContainer createTestContainer1() {
        EmptyBlock b1 = new EmptyBlock(10.0, 11.0);
        EmptyBlock b2 = new EmptyBlock(20.0, 22.0);
        EmptyBlock b3 = new EmptyBlock(30.0, 33.0);
        BlockContainer result = new BlockContainer(new GridArrangement(1, 3));
        result.add(b1);
        result.add(b2);
        result.add(b3);
        return result;
    }
}

