/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.Range;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ValueAxisTests
extends TestCase {
    private static final double EPSILON = 1.0E-9;

    public static Test suite() {
        return new TestSuite(ValueAxisTests.class);
    }

    public ValueAxisTests(String name) {
        super(name);
    }

    public void testCloning() {
        NumberAxis a1 = new NumberAxis("Test");
        NumberAxis a2 = null;
        try {
            a2 = (NumberAxis)((ValueAxis)a1).clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("ValueAxisTests.testCloning: failed to clone.");
        }
        ValueAxisTests.assertTrue((a1 != a2 ? 1 : 0) != 0);
        ValueAxisTests.assertTrue((a1.getClass() == a2.getClass() ? 1 : 0) != 0);
        ValueAxisTests.assertTrue((boolean)((ValueAxis)a1).equals(a2));
    }

    public void testEquals() {
        NumberAxis a1 = new NumberAxis("Test");
        NumberAxis a2 = new NumberAxis("Test");
        ValueAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setAxisLineVisible(false);
        ValueAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setAxisLineVisible(false);
        ValueAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setPositiveArrowVisible(true);
        ValueAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setPositiveArrowVisible(true);
        ValueAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setNegativeArrowVisible(true);
        ValueAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setNegativeArrowVisible(true);
        ValueAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setAxisLinePaint(Color.blue);
        ValueAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setAxisLinePaint(Color.blue);
        ValueAxisTests.assertTrue((boolean)a1.equals(a2));
        BasicStroke stroke = new BasicStroke(2.0f);
        a1.setAxisLineStroke(stroke);
        ValueAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setAxisLineStroke(stroke);
        ValueAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setInverted(true);
        ValueAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setInverted(true);
        ValueAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setRange(new Range(50.0, 75.0));
        ValueAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setRange(new Range(50.0, 75.0));
        ValueAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setAutoRange(true);
        ValueAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setAutoRange(true);
        ValueAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setAutoRangeMinimumSize(3.33);
        ValueAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setAutoRangeMinimumSize(3.33);
        ValueAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setUpperMargin(0.09);
        ValueAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setUpperMargin(0.09);
        ValueAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setLowerMargin(0.09);
        ValueAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setLowerMargin(0.09);
        ValueAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setFixedAutoRange(50.0);
        ValueAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setFixedAutoRange(50.0);
        ValueAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setAutoTickUnitSelection(false);
        ValueAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setAutoTickUnitSelection(false);
        ValueAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        ValueAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        ValueAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setVerticalTickLabels(true);
        ValueAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setVerticalTickLabels(true);
        ValueAxisTests.assertTrue((boolean)a1.equals(a2));
    }

    public void testAxisMargins() {
        XYSeries series = new XYSeries((Comparable)((Object)"S1"));
        series.add(100.0, 1.1);
        series.add(200.0, 2.2);
        XYSeriesCollection dataset = new XYSeriesCollection(series);
        dataset.setIntervalWidth(0.0);
        JFreeChart chart = ChartFactory.createScatterPlot("Title", "X", "Y", dataset, PlotOrientation.VERTICAL, false, false, false);
        ValueAxis domainAxis = chart.getXYPlot().getDomainAxis();
        Range r = domainAxis.getRange();
        ValueAxisTests.assertEquals((double)110.0, (double)r.getLength(), (double)1.0E-9);
        domainAxis.setLowerMargin(0.1);
        domainAxis.setUpperMargin(0.1);
        r = domainAxis.getRange();
        ValueAxisTests.assertEquals((double)120.0, (double)r.getLength(), (double)1.0E-9);
    }
}

