/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import junit.framework.TestCase;
import org.jfree.chart.axis.SegmentedTimeline;

public class SegmentedTimelineTests2
extends TestCase {
    public void test1() {
        Calendar cal = Calendar.getInstance(Locale.UK);
        cal.set(1, 2004);
        cal.set(2, 2);
        cal.set(5, 26);
        cal.set(11, 9);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date date = cal.getTime();
        SegmentedTimeline timeline = this.getTimeline();
        long value = timeline.toTimelineValue(date);
        long ms = timeline.toMillisecond(value);
        Calendar cal2 = Calendar.getInstance(Locale.UK);
        cal2.setTime(new Date(ms));
        Date reverted = cal2.getTime();
        SegmentedTimelineTests2.assertTrue((String)"test1", (value == 30600000L && date.getTime() == reverted.getTime() ? 1 : 0) != 0);
    }

    public void test2() {
        Calendar cal = Calendar.getInstance(Locale.UK);
        cal.set(1, 2004);
        cal.set(2, 2);
        cal.set(5, 26);
        cal.set(11, 9);
        cal.set(12, 15);
        cal.set(13, 0);
        cal.set(14, 0);
        Date date = cal.getTime();
        SegmentedTimeline timeline = this.getTimeline();
        long value = timeline.toTimelineValue(date);
        long ms = timeline.toMillisecond(value);
        Calendar cal2 = Calendar.getInstance(Locale.UK);
        cal2.setTime(new Date(ms));
        Date reverted = cal2.getTime();
        SegmentedTimelineTests2.assertTrue((String)"test2", (value == 31500000L && date.getTime() == reverted.getTime() ? 1 : 0) != 0);
    }

    public void test3() {
        Calendar cal = Calendar.getInstance(Locale.UK);
        cal.set(1, 2004);
        cal.set(2, 2);
        cal.set(5, 26);
        cal.set(11, 9);
        cal.set(12, 30);
        cal.set(13, 0);
        cal.set(14, 0);
        Date date = cal.getTime();
        SegmentedTimeline timeline = this.getTimeline();
        long value = timeline.toTimelineValue(date);
        long ms = timeline.toMillisecond(value);
        Calendar cal2 = Calendar.getInstance(Locale.UK);
        cal2.setTime(new Date(ms));
        Date reverted = cal2.getTime();
        SegmentedTimelineTests2.assertTrue((String)"test2", (value == 32400000L && date.getTime() == reverted.getTime() ? 1 : 0) != 0);
    }

    public void test4() {
        Calendar cal = Calendar.getInstance(Locale.UK);
        cal.set(1, 2004);
        cal.set(2, 2);
        cal.set(5, 26);
        cal.set(11, 9);
        cal.set(12, 30);
        cal.set(13, 0);
        cal.set(14, 1);
        Date date = cal.getTime();
        SegmentedTimeline timeline = this.getTimeline();
        long value = timeline.toTimelineValue(date);
        long ms = timeline.toMillisecond(value);
        Calendar cal2 = Calendar.getInstance(Locale.UK);
        cal2.setTime(new Date(ms));
        Date reverted = cal2.getTime();
        SegmentedTimelineTests2.assertTrue((String)"test4", (value == 32400001L && date.getTime() == reverted.getTime() ? 1 : 0) != 0);
    }

    public void test5() {
        Calendar cal = Calendar.getInstance(Locale.UK);
        cal.set(1, 2004);
        cal.set(2, 2);
        cal.set(5, 25);
        cal.set(11, 17);
        cal.set(12, 30);
        cal.set(13, 0);
        cal.set(14, 0);
        Date date = cal.getTime();
        SegmentedTimeline timeline = this.getTimeline();
        long value = timeline.toTimelineValue(date);
        long ms = timeline.toMillisecond(value);
        Calendar cal2 = Calendar.getInstance(Locale.UK);
        cal2.setTime(new Date(ms));
        Date reverted = cal2.getTime();
        Calendar expectedReverted = Calendar.getInstance(Locale.UK);
        expectedReverted.set(1, 2004);
        expectedReverted.set(2, 2);
        expectedReverted.set(5, 26);
        expectedReverted.set(11, 9);
        expectedReverted.set(12, 0);
        expectedReverted.set(13, 0);
        expectedReverted.set(14, 0);
        SegmentedTimelineTests2.assertTrue((String)"test5", (value == 30600000L && expectedReverted.getTime().getTime() == reverted.getTime() ? 1 : 0) != 0);
    }

    public void test6() {
        Calendar cal = Calendar.getInstance(Locale.UK);
        cal.set(1, 2004);
        cal.set(2, 2);
        cal.set(5, 28);
        cal.set(11, 9);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date date = cal.getTime();
        SegmentedTimeline timeline = this.getTimeline();
        long value = timeline.toTimelineValue(date);
        long ms = timeline.toMillisecond(value);
        Calendar cal2 = Calendar.getInstance(Locale.UK);
        cal2.setTime(new Date(ms));
        Date reverted = cal2.getTime();
        Calendar expectedReverted = Calendar.getInstance(Locale.UK);
        expectedReverted.set(1, 2004);
        expectedReverted.set(2, 2);
        expectedReverted.set(5, 29);
        expectedReverted.set(11, 9);
        expectedReverted.set(12, 0);
        expectedReverted.set(13, 0);
        expectedReverted.set(14, 0);
        SegmentedTimelineTests2.assertTrue((String)"test6", (value == 61200000L && expectedReverted.getTime().getTime() == reverted.getTime() ? 1 : 0) != 0);
    }

    public void test7() {
        Calendar cal = Calendar.getInstance(Locale.UK);
        cal.set(1, 2004);
        cal.set(2, 2);
        cal.set(5, 29);
        cal.set(11, 9);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date date = cal.getTime();
        SegmentedTimeline timeline = this.getTimeline();
        long value = timeline.toTimelineValue(date);
        long ms = timeline.toMillisecond(value);
        Calendar cal2 = Calendar.getInstance(Locale.UK);
        cal2.setTime(new Date(ms));
        Date reverted = cal2.getTime();
        Calendar expectedReverted = Calendar.getInstance();
        expectedReverted.set(1, 2004);
        expectedReverted.set(2, 2);
        expectedReverted.set(5, 29);
        expectedReverted.set(11, 9);
        expectedReverted.set(12, 0);
        expectedReverted.set(13, 0);
        expectedReverted.set(14, 0);
        SegmentedTimelineTests2.assertTrue((String)"test7", (value == 61200000L && expectedReverted.getTime().getTime() == reverted.getTime() ? 1 : 0) != 0);
    }

    public void test8() {
        Calendar cal = Calendar.getInstance(Locale.UK);
        cal.set(1, 2004);
        cal.set(2, 2);
        cal.set(5, 29);
        cal.set(11, 10);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date date = cal.getTime();
        SegmentedTimeline timeline = this.getTimeline();
        cal.set(1, 2004);
        cal.set(2, 2);
        cal.set(5, 29);
        cal.set(11, 9);
        cal.set(12, 15);
        cal.set(13, 0);
        cal.set(14, 0);
        timeline.addException(cal.getTime());
        long value = timeline.toTimelineValue(date);
        long ms = timeline.toMillisecond(value);
        Calendar cal2 = Calendar.getInstance(Locale.UK);
        cal2.setTime(new Date(ms));
        Date reverted = cal2.getTime();
        Calendar expectedReverted = Calendar.getInstance();
        expectedReverted.set(1, 2004);
        expectedReverted.set(2, 2);
        expectedReverted.set(5, 29);
        expectedReverted.set(11, 10);
        expectedReverted.set(12, 0);
        expectedReverted.set(13, 0);
        expectedReverted.set(14, 0);
        SegmentedTimelineTests2.assertTrue((String)"test8", (value == 63900000L && expectedReverted.getTime().getTime() == reverted.getTime() ? 1 : 0) != 0);
    }

    private SegmentedTimeline getTimeline() {
        Calendar cal = Calendar.getInstance(Locale.UK);
        cal.set(1, 2004);
        cal.set(2, 2);
        cal.set(5, 25);
        cal.set(11, 9);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date from = cal.getTime();
        cal = Calendar.getInstance(Locale.UK);
        cal.set(1, 2004);
        cal.set(2, 2);
        cal.set(5, 30);
        cal.set(11, 17);
        cal.set(12, 30);
        cal.set(13, 0);
        cal.set(14, 0);
        Date to = cal.getTime();
        return this.getTimeline(from, to);
    }

    private SegmentedTimeline getTimeline(Date start, Date end) {
        Calendar cal = Calendar.getInstance(Locale.UK);
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 9);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date open = cal.getTime();
        cal = Calendar.getInstance(Locale.UK);
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 17);
        cal.set(12, 30);
        cal.set(13, 0);
        cal.set(14, 0);
        Date close = cal.getTime();
        SegmentedTimeline result = null;
        long quarterHourCount = (close.getTime() - open.getTime()) / 900000L;
        long totalQuarterHourCount = 96L;
        result = new SegmentedTimeline(900000L, (int)quarterHourCount, (int)(totalQuarterHourCount - quarterHourCount));
        result.setAdjustForDaylightSaving(true);
        result.setStartTime(start.getTime());
        result.setBaseTimeline(SegmentedTimeline.newMondayThroughFridayTimeline());
        if (start != null && end != null) {
            result.addBaseTimelineExclusions(start.getTime(), end.getTime());
        }
        return result;
    }
}

