/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.QuarterDateFormat;

public class QuarterDateFormatTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(QuarterDateFormatTests.class);
    }

    public QuarterDateFormatTests(String name) {
        super(name);
    }

    public void testEquals() {
        QuarterDateFormat qf1 = new QuarterDateFormat(TimeZone.getTimeZone("GMT"), new String[]{"1", "2", "3", "4"});
        QuarterDateFormat qf2 = new QuarterDateFormat(TimeZone.getTimeZone("GMT"), new String[]{"1", "2", "3", "4"});
        QuarterDateFormatTests.assertTrue((boolean)qf1.equals(qf2));
        QuarterDateFormatTests.assertTrue((boolean)qf2.equals(qf1));
        qf1 = new QuarterDateFormat(TimeZone.getTimeZone("PST"), new String[]{"1", "2", "3", "4"});
        QuarterDateFormatTests.assertFalse((boolean)qf1.equals(qf2));
        qf2 = new QuarterDateFormat(TimeZone.getTimeZone("PST"), new String[]{"1", "2", "3", "4"});
        QuarterDateFormatTests.assertTrue((boolean)qf1.equals(qf2));
        qf1 = new QuarterDateFormat(TimeZone.getTimeZone("PST"), new String[]{"A", "2", "3", "4"});
        QuarterDateFormatTests.assertFalse((boolean)qf1.equals(qf2));
        qf2 = new QuarterDateFormat(TimeZone.getTimeZone("PST"), new String[]{"A", "2", "3", "4"});
        QuarterDateFormatTests.assertTrue((boolean)qf1.equals(qf2));
    }

    public void testHashCode() {
        QuarterDateFormat qf1 = new QuarterDateFormat(TimeZone.getTimeZone("GMT"), new String[]{"1", "2", "3", "4"});
        QuarterDateFormat qf2 = new QuarterDateFormat(TimeZone.getTimeZone("GMT"), new String[]{"1", "2", "3", "4"});
        QuarterDateFormatTests.assertTrue((boolean)qf1.equals(qf2));
        int h1 = qf1.hashCode();
        int h2 = qf2.hashCode();
        QuarterDateFormatTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        QuarterDateFormat qf1 = new QuarterDateFormat(TimeZone.getTimeZone("GMT"), new String[]{"1", "2", "3", "4"});
        QuarterDateFormat qf2 = null;
        qf2 = (QuarterDateFormat)qf1.clone();
        QuarterDateFormatTests.assertTrue((qf1 != qf2 ? 1 : 0) != 0);
        QuarterDateFormatTests.assertTrue((qf1.getClass() == qf2.getClass() ? 1 : 0) != 0);
        QuarterDateFormatTests.assertTrue((boolean)qf1.equals(qf2));
    }

    public void testSerialization() {
        QuarterDateFormat qf1 = new QuarterDateFormat(TimeZone.getTimeZone("GMT"), new String[]{"1", "2", "3", "4"});
        QuarterDateFormat qf2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(qf1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            qf2 = (QuarterDateFormat)in.readObject();
            in.close();
        }
        catch (Exception e) {
            QuarterDateFormatTests.fail((String)e.toString());
        }
        QuarterDateFormatTests.assertTrue((boolean)qf1.equals(qf2));
    }
}

