/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.PeriodAxis;
import org.jfree.chart.axis.PeriodAxisLabelInfo;
import org.jfree.data.time.Day;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.Second;
import org.jfree.data.time.Year;

public class PeriodAxisTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(PeriodAxisTests.class);
    }

    public PeriodAxisTests(String name) {
        super(name);
    }

    public void testEquals() {
        PeriodAxis a1 = new PeriodAxis("Test");
        PeriodAxis a2 = new PeriodAxis("Test");
        PeriodAxisTests.assertTrue((boolean)a1.equals(a2));
        PeriodAxisTests.assertTrue((boolean)a2.equals(a1));
        a1.setFirst(new Year(2000));
        PeriodAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setFirst(new Year(2000));
        PeriodAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setLast(new Year(2004));
        PeriodAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setLast(new Year(2004));
        PeriodAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setTimeZone(TimeZone.getTimeZone("Pacific/Auckland"));
        PeriodAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setTimeZone(TimeZone.getTimeZone("Pacific/Auckland"));
        PeriodAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setAutoRangeTimePeriodClass(Quarter.class);
        PeriodAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setAutoRangeTimePeriodClass(Quarter.class);
        PeriodAxisTests.assertTrue((boolean)a1.equals(a2));
        PeriodAxisLabelInfo[] info = new PeriodAxisLabelInfo[]{new PeriodAxisLabelInfo(Month.class, new SimpleDateFormat("MMM"))};
        a1.setLabelInfo(info);
        PeriodAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setLabelInfo(info);
        PeriodAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setMajorTickTimePeriodClass(Minute.class);
        PeriodAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setMajorTickTimePeriodClass(Minute.class);
        PeriodAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setMinorTickMarksVisible(!a1.isMinorTickMarksVisible());
        PeriodAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setMinorTickMarksVisible(a1.isMinorTickMarksVisible());
        PeriodAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setMinorTickTimePeriodClass(Minute.class);
        PeriodAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setMinorTickTimePeriodClass(Minute.class);
        PeriodAxisTests.assertTrue((boolean)a1.equals(a2));
        BasicStroke s = new BasicStroke(1.23f);
        a1.setMinorTickMarkStroke(s);
        PeriodAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setMinorTickMarkStroke(s);
        PeriodAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setMinorTickMarkPaint(Color.blue);
        PeriodAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setMinorTickMarkPaint(Color.blue);
        PeriodAxisTests.assertTrue((boolean)a1.equals(a2));
    }

    public void testHashCode() {
        PeriodAxis a1 = new PeriodAxis("Test");
        PeriodAxis a2 = new PeriodAxis("Test");
        PeriodAxisTests.assertTrue((boolean)a1.equals(a2));
        int h1 = a1.hashCode();
        int h2 = a2.hashCode();
        PeriodAxisTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        PeriodAxis a1 = new PeriodAxis("Test");
        PeriodAxis a2 = null;
        try {
            a2 = (PeriodAxis)a1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        PeriodAxisTests.assertTrue((a1 != a2 ? 1 : 0) != 0);
        PeriodAxisTests.assertTrue((a1.getClass() == a2.getClass() ? 1 : 0) != 0);
        PeriodAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setLabel("New Label");
        PeriodAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setLabel("New Label");
        PeriodAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setFirst(new Year(1920));
        PeriodAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setFirst(new Year(1920));
        PeriodAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setLast(new Year(2020));
        PeriodAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setLast(new Year(2020));
        PeriodAxisTests.assertTrue((boolean)a1.equals(a2));
        PeriodAxisLabelInfo[] info = new PeriodAxisLabelInfo[]{new PeriodAxisLabelInfo(Day.class, new SimpleDateFormat("d")), new PeriodAxisLabelInfo(Year.class, new SimpleDateFormat("yyyy"))};
        a1.setLabelInfo(info);
        PeriodAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setLabelInfo(info);
        PeriodAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setAutoRangeTimePeriodClass(Second.class);
        PeriodAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setAutoRangeTimePeriodClass(Second.class);
        PeriodAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setTimeZone(new SimpleTimeZone(123, "Bogus"));
        PeriodAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setTimeZone(new SimpleTimeZone(123, "Bogus"));
        PeriodAxisTests.assertTrue((boolean)a1.equals(a2));
    }

    public void testSerialization() {
        PeriodAxis a1 = new PeriodAxis("Test Axis");
        PeriodAxis a2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(a1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            a2 = (PeriodAxis)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        boolean b = a1.equals(a2);
        PeriodAxisTests.assertTrue((boolean)b);
    }
}

