/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.CyclicNumberAxis;

public class CyclicNumberAxisTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CyclicNumberAxisTests.class);
    }

    public CyclicNumberAxisTests(String name) {
        super(name);
    }

    public void testCloning() {
        CyclicNumberAxis a1 = new CyclicNumberAxis(10.0, 0.0, "Test");
        CyclicNumberAxis a2 = null;
        try {
            a2 = (CyclicNumberAxis)a1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        CyclicNumberAxisTests.assertTrue((a1 != a2 ? 1 : 0) != 0);
        CyclicNumberAxisTests.assertTrue((a1.getClass() == a2.getClass() ? 1 : 0) != 0);
        CyclicNumberAxisTests.assertTrue((boolean)a1.equals(a2));
    }

    public void testEquals() {
        CyclicNumberAxis a1 = new CyclicNumberAxis(10.0, 0.0, "Test");
        CyclicNumberAxis a2 = new CyclicNumberAxis(10.0, 0.0, "Test");
        CyclicNumberAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setPeriod(5.0);
        CyclicNumberAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setPeriod(5.0);
        CyclicNumberAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setOffset(2.0);
        CyclicNumberAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setOffset(2.0);
        CyclicNumberAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setAdvanceLinePaint(Color.cyan);
        CyclicNumberAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setAdvanceLinePaint(Color.cyan);
        CyclicNumberAxisTests.assertTrue((boolean)a1.equals(a2));
        BasicStroke stroke = new BasicStroke(0.2f);
        a1.setAdvanceLineStroke(stroke);
        CyclicNumberAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setAdvanceLineStroke(stroke);
        CyclicNumberAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setAdvanceLineVisible(!a1.isAdvanceLineVisible());
        CyclicNumberAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setAdvanceLineVisible(a1.isAdvanceLineVisible());
        CyclicNumberAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setBoundMappedToLastCycle(!a1.isBoundMappedToLastCycle());
        CyclicNumberAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setBoundMappedToLastCycle(a1.isBoundMappedToLastCycle());
        CyclicNumberAxisTests.assertTrue((boolean)a1.equals(a2));
    }

    public void testHashCode() {
        CyclicNumberAxis a1 = new CyclicNumberAxis(10.0, 0.0, "Test");
        CyclicNumberAxis a2 = new CyclicNumberAxis(10.0, 0.0, "Test");
        CyclicNumberAxisTests.assertTrue((boolean)a1.equals(a2));
        int h1 = a1.hashCode();
        int h2 = a2.hashCode();
        CyclicNumberAxisTests.assertEquals((int)h1, (int)h2);
    }

    public void testSerialization() {
        CyclicNumberAxis a1 = new CyclicNumberAxis(10.0, 0.0, "Test Axis");
        CyclicNumberAxis a2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(a1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            a2 = (CyclicNumberAxis)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        CyclicNumberAxisTests.assertEquals((Object)a1, a2);
    }
}

