/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.ui.RectangleInsets;

public class AxisTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(AxisTests.class);
    }

    public AxisTests(String name) {
        super(name);
    }

    public void testCloning() {
        CategoryAxis a1 = new CategoryAxis("Test");
        a1.setAxisLinePaint(Color.red);
        CategoryAxis a2 = null;
        try {
            a2 = (CategoryAxis)a1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        AxisTests.assertTrue((a1 != a2 ? 1 : 0) != 0);
        AxisTests.assertTrue((a1.getClass() == a2.getClass() ? 1 : 0) != 0);
        AxisTests.assertTrue((boolean)a1.equals(a2));
    }

    public void testEquals() {
        CategoryAxis a1 = new CategoryAxis("Test");
        CategoryAxis a2 = new CategoryAxis("Test");
        AxisTests.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setVisible(false);
        AxisTests.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setVisible(false);
        AxisTests.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setLabel("New Label");
        AxisTests.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setLabel("New Label");
        AxisTests.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setLabelFont(new Font("Dialog", 0, 8));
        AxisTests.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setLabelFont(new Font("Dialog", 0, 8));
        AxisTests.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setLabelPaint(Color.blue);
        AxisTests.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setLabelPaint(Color.blue);
        AxisTests.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setLabelInsets(new RectangleInsets(10.0, 10.0, 10.0, 10.0));
        AxisTests.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setLabelInsets(new RectangleInsets(10.0, 10.0, 10.0, 10.0));
        AxisTests.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setLabelAngle(1.23);
        AxisTests.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setLabelAngle(1.23);
        AxisTests.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setAxisLineVisible(false);
        AxisTests.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setAxisLineVisible(false);
        AxisTests.assertTrue((boolean)((Axis)a1).equals(a2));
        BasicStroke s = new BasicStroke(1.1f);
        a1.setAxisLineStroke(s);
        AxisTests.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setAxisLineStroke(s);
        AxisTests.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setAxisLinePaint(Color.blue);
        AxisTests.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setAxisLinePaint(Color.blue);
        AxisTests.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setTickLabelsVisible(false);
        AxisTests.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setTickLabelsVisible(false);
        AxisTests.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setTickLabelFont(new Font("Dialog", 0, 12));
        AxisTests.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setTickLabelFont(new Font("Dialog", 0, 12));
        AxisTests.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setTickLabelPaint(Color.red);
        AxisTests.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setTickLabelPaint(Color.red);
        AxisTests.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setTickLabelInsets(new RectangleInsets(10.0, 10.0, 10.0, 10.0));
        AxisTests.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setTickLabelInsets(new RectangleInsets(10.0, 10.0, 10.0, 10.0));
        AxisTests.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setTickMarksVisible(true);
        AxisTests.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setTickMarksVisible(true);
        AxisTests.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setTickMarkInsideLength(1.23f);
        AxisTests.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setTickMarkInsideLength(1.23f);
        AxisTests.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setTickMarkOutsideLength(1.23f);
        AxisTests.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setTickMarkOutsideLength(1.23f);
        AxisTests.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setTickMarkStroke(new BasicStroke(2.0f));
        AxisTests.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setTickMarkStroke(new BasicStroke(2.0f));
        AxisTests.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setTickMarkPaint(Color.green);
        AxisTests.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setTickMarkPaint(Color.green);
        AxisTests.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setFixedDimension(3.21f);
        AxisTests.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setFixedDimension(3.21f);
        AxisTests.assertTrue((boolean)((Axis)a1).equals(a2));
    }

    public void testHashCode() {
        CategoryAxis a1 = new CategoryAxis("Test");
        CategoryAxis a2 = new CategoryAxis("Test");
        AxisTests.assertTrue((boolean)((Axis)a1).equals(a2));
        int h1 = ((Object)a1).hashCode();
        int h2 = ((Object)a2).hashCode();
        AxisTests.assertEquals((int)h1, (int)h2);
    }
}

