/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations.junit;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.ui.TextAnchor;

public class XYTextAnnotationTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYTextAnnotationTests.class);
    }

    public XYTextAnnotationTests(String name) {
        super(name);
    }

    public void testEquals() {
        XYTextAnnotation a1 = new XYTextAnnotation("Text", 10.0, 20.0);
        XYTextAnnotation a2 = new XYTextAnnotation("Text", 10.0, 20.0);
        XYTextAnnotationTests.assertTrue((boolean)a1.equals(a2));
        a1 = new XYTextAnnotation("ABC", 10.0, 20.0);
        XYTextAnnotationTests.assertFalse((boolean)a1.equals(a2));
        a2 = new XYTextAnnotation("ABC", 10.0, 20.0);
        XYTextAnnotationTests.assertTrue((boolean)a1.equals(a2));
        a1.setFont(new Font("Serif", 0, 23));
        XYTextAnnotationTests.assertFalse((boolean)a1.equals(a2));
        a2.setFont(new Font("Serif", 0, 23));
        XYTextAnnotationTests.assertTrue((boolean)a1.equals(a2));
        GradientPaint gp1 = new GradientPaint(1.0f, 2.0f, Color.red, 3.0f, 4.0f, Color.yellow);
        GradientPaint gp2 = new GradientPaint(1.0f, 2.0f, Color.red, 3.0f, 4.0f, Color.yellow);
        a1.setPaint(gp1);
        XYTextAnnotationTests.assertFalse((boolean)a1.equals(a2));
        a2.setPaint(gp2);
        XYTextAnnotationTests.assertTrue((boolean)a1.equals(a2));
        a1.setRotationAnchor(TextAnchor.BASELINE_RIGHT);
        XYTextAnnotationTests.assertFalse((boolean)a1.equals(a2));
        a2.setRotationAnchor(TextAnchor.BASELINE_RIGHT);
        XYTextAnnotationTests.assertTrue((boolean)a1.equals(a2));
        a1.setRotationAngle(12.3);
        XYTextAnnotationTests.assertFalse((boolean)a1.equals(a2));
        a2.setRotationAngle(12.3);
        XYTextAnnotationTests.assertTrue((boolean)a1.equals(a2));
        a1.setTextAnchor(TextAnchor.BASELINE_RIGHT);
        XYTextAnnotationTests.assertFalse((boolean)a1.equals(a2));
        a2.setTextAnchor(TextAnchor.BASELINE_RIGHT);
        XYTextAnnotationTests.assertTrue((boolean)a1.equals(a2));
    }

    public void testHashCode() {
        XYTextAnnotation a1 = new XYTextAnnotation("Text", 10.0, 20.0);
        XYTextAnnotation a2 = new XYTextAnnotation("Text", 10.0, 20.0);
        XYTextAnnotationTests.assertTrue((boolean)a1.equals(a2));
        int h1 = a1.hashCode();
        int h2 = a2.hashCode();
        XYTextAnnotationTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        XYTextAnnotation a1 = new XYTextAnnotation("Text", 10.0, 20.0);
        XYTextAnnotation a2 = null;
        try {
            a2 = (XYTextAnnotation)a1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        XYTextAnnotationTests.assertTrue((a1 != a2 ? 1 : 0) != 0);
        XYTextAnnotationTests.assertTrue((a1.getClass() == a2.getClass() ? 1 : 0) != 0);
        XYTextAnnotationTests.assertTrue((boolean)a1.equals(a2));
    }

    public void testSerialization() {
        XYTextAnnotation a1 = new XYTextAnnotation("Text", 10.0, 20.0);
        XYTextAnnotation a2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(a1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            a2 = (XYTextAnnotation)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        XYTextAnnotationTests.assertEquals((Object)a1, a2);
    }
}

