package dom.event;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.dom.EventObject;
import com.jniwrapper.win32.ie.dom.EventObjectFactory;
import com.jniwrapper.win32.ie.dom.HTMLElement;
import core.BasicSample;

/**
 * This sample fires click event on DIV element.
 *
 * @author Alexei Orischenko
 */
public class FireEventSample extends BasicSample
{
    private static final String HTML_CONTENT = "<html>" +
            "<head>" +
            "<script>" +
            "function clickHandler(elem) { " +
            "alert('clicked on element: ' + elem.tagName + ', x = ' + event.clientX + ', y = ' + event.clientY); " +
            "}" +
            "</script>" +
            "</head>" +
            "<body>" +
            "<div id=\"eventDiv\" style='background: #cccccc; width:400; height:300' onclick=\"clickHandler(this)\">Click on the DIV element to display alert</div>" +
            "</body>" +
            "</html>";

    public FireEventSample()
    {
        super("Fire Event");
    }

    protected void execute()
    {
        WebBrowser browser = getBrowser();

        // wait when the browser will be ready to work
        browser.waitReady();

        browser.setContent(HTML_CONTENT);
        browser.waitReady();

        HTMLElement div = (HTMLElement)getBrowser().getDocument().getElementById("eventDiv");

        showMessage("Generate click event");

        // fires event with parameters
        div.fireEvent("onclick", new EventObjectFactory()
        {
            public EventObject create()
            {
                EventObject eventObject = new EventObject();
                eventObject.setClientX(15);
                eventObject.setClientY(15);
                return eventObject;
            }
        });
    }

    public static void main(String[] args) throws Exception
    {
        new FireEventSample().run();
    }
}
