package dom;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.dom.HTMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

import java.awt.*;

import core.BasicSample;

/**
 * This sample demonstrates the technique of working with DOM element styles.
 *
 * @author Alexei Orischenko
 */
public class StyleSample extends BasicSample
{
    public StyleSample()
    {
        super("Style");
    }

    protected void execute()
    {
        WebBrowser browser = getBrowser();

        // wait when the browser will be ready to work
        browser.waitReady();

        browser.navigate("http://google.com");
        browser.waitReady();

        showMessage("Change element styles");

        NodeList fontElements = browser.getDocument().getElementsByTagName("font");

        if (fontElements.getLength() > 0)
        {
            HTMLElement fontElement = (HTMLElement) fontElements.item(fontElements.getLength() - 1);

            // set green background for last font element
            fontElement.setStyle("background", "green");
        } else
        {
            showMessage("Can't find font elements in the page");
        }

        // set red border for text field
        HTMLElement inputElement = getTextInput(browser.getDocument());
        inputElement.setBorder(Color.RED);
    }

    private static HTMLElement getTextInput(Document document)
    {
        NodeList inputs = document.getElementsByTagName("input");

        for (int i = 0; i < inputs.getLength(); i++)
        {
            HTMLElement input = (HTMLElement) inputs.item(i);
            String type = input.getAttribute("type").toLowerCase();

            if ("text".equals(type))
            {
                return input;
            }
        }

        return null;
    }

    public static void main(String[] args) throws Exception
    {
        new StyleSample().run();
    }
}
