package dom;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.dom.HTMLDocument;
import core.BasicSample;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/**
 * This sample demonstrates creation of elements that belong to some namespace (contain prefix in the
 * tag name, like jniw:info).
 * <p/>
 * <p>The main requirement for creation element in namespace is the namespace declared in the
 * html element of the document.
 *
 * @author Alexei Orischenko
 */
public class NamespaceSample extends BasicSample
{
    public NamespaceSample()
    {
        super("Namespace");
    }

    protected void execute()
    {
        WebBrowser browser = getBrowser();

        browser.setContent("<html XMLNS:jniw=\"www.teamdev.com\"><body></body></html>");
        browser.waitReady();

        HTMLDocument doc = browser.getDocument();
        Element elem = doc.createElement("jniw:info");
        Text text = doc.createTextNode("JExplorer 1.7");

        elem.appendChild(text);
        doc.getBody().appendChild(elem);

        String content = browser.getContent();
        showMessage("JExplorer Content", content);
    }

    public static void main(String[] args) throws Exception
    {
        new NamespaceSample().run();
    }
}
