package dom;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.Int32;
import com.jniwrapper.win32.automation.types.BStr;
import com.jniwrapper.win32.com.IUnknown;
import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.dom.HTMLElement;
import com.jniwrapper.win32.mshtml.IHTMLStyleElement;
import com.jniwrapper.win32.mshtml.IHTMLStyleSheet;
import com.jniwrapper.win32.mshtml.IHTMLElement;
import com.jniwrapper.win32.mshtml.IHTMLStyle;
import com.jniwrapper.win32.mshtml.impl.IHTMLStyleElementImpl;
import core.BasicSample;
import org.w3c.dom.NodeList;

/**
 * This sample demonstrates how to add new style for the document.
 *
 * @author Alexei Orischenko
 */
public class AddStyleSample extends BasicSample {
    public AddStyleSample() {
        super("Add Style");
    }

    protected void execute() {
        WebBrowser browser = getBrowser();
        browser.setContent("<html><head>" +
                "<style>" +
                ".p1 { background: gray; }" +
                "</style>" +
                "</head>" +
                "<body><p class='p1'>para 1</p>" +
                "<p class='p2'>para 2</p>" +
                "</body></html>");

        browser.waitReady();
        HTMLElement body = browser.getDocument().getBody();

        // using peer level
        IHTMLElement elementPeer = (IHTMLElement)body.getElementPeer();
        IHTMLStyle htmlStyle = elementPeer.getStyle();
        BStr cssText = htmlStyle.getCssText();
        System.out.println("cssText = " + cssText);
        htmlStyle.setCssText(new BStr("background: gray"));

        try {
            Thread.sleep(1000);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }

        // using wrapper
        body.setStyle("background", "green");

        // using the slyle collection
        NodeList styles = browser.getDocument().getElementsByTagName("style");
        if (styles.getLength() > 0) {
            HTMLElement style = (HTMLElement) styles.item(0);
            final Object peer = style.getElementPeer();
            showMessage("Add red background style for paragraph");
            try {
                browser.getOleMessageLoop().doInvokeAndWait(new Runnable() {
                    public void run() {
                        IHTMLStyleElement styleElement = new IHTMLStyleElementImpl((IUnknown) peer);
                        IHTMLStyleSheet styleSheet = styleElement.getStyleSheet();
                        styleSheet.addRule(new BStr("p"), new BStr("background: red"), new Int32(-1));
                        styleSheet.addRule(new BStr(".p1"), new BStr("margin-left: 50px"), new Int32(-1));
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new AddStyleSample().run();
    }
}
