package core;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.WebBrowser;

import javax.swing.JOptionPane;
import java.awt.Component;

/**
 * This sample demonstrates the technique of using browser history and refreshing document.
 *
 * @author Alexei Orischenko
 */
public class NavigationSample extends BasicSample
{
    public NavigationSample()
    {
        super("Navigation");
    }

    protected void execute()
    {
        WebBrowser browser = getBrowser();

        // wait when the browser will be ready to work
        browser.waitReady();

        browser.navigate("www.teamdev.com");
        browser.waitReady();

        JOptionPane.showMessageDialog((Component) browser, "Browser will load Google page");

        browser.navigate("www.google.com");
        browser.waitReady();

        JOptionPane.showMessageDialog((Component) browser, "Browser will go back");

        browser.goBack();
        browser.waitReady();

        JOptionPane.showMessageDialog((Component) browser, "Browser will go forward");

        browser.goForward();
        browser.waitReady();

        JOptionPane.showMessageDialog((Component) browser, "Browser will refresh page");

        browser.refresh();
        browser.waitReady();
    }

    public static void main(String[] args) throws Exception
    {
        new NavigationSample().run();
    }
}
