package core;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.dom.FontSize;

/**
 * This sample demonstrates technique of working with document font size
 * (like through View > Text Size menu).
 *
 * @author Alexei Orischenko
 */
public class FontSizeSample extends BasicSample
{
    public FontSizeSample()
    {
        super("Font Size");
    }

    protected void execute()
    {
        WebBrowser browser = getBrowser();
        browser.navigate("http://www.google.com");
        browser.waitReady();

        showMessage("Set largest font size.");

        // set large font size
        browser.getDocument().setFontSize(FontSize.LARGEST);

        showMessage("Set medium font size.");

        // set medium font size
        browser.getDocument().setFontSize(FontSize.MEDIUM);
    }

    public static void main(String[] args) throws Exception
    {
        new FontSizeSample().run();
    }
}
