package contextmenu;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.Browser;
import com.jniwrapper.win32.ie.ContextMenuProvider;
import org.w3c.dom.Element;

import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

import core.BasicSample;

/**
 * This sample setups right click event listener.
 *
 * @author Alexei Orischenko
 */
public class ContextMenuActionSample extends BasicSample
{
    public ContextMenuActionSample()
    {
        super("Context Menu Action");
    }

    protected void execute()
    {
        Browser browser = (Browser)getBrowser();

        browser.setContextMenuProvider(new ContextMenuProvider()
        {
            public JPopupMenu getPopupMenu(Element contextElement)
            {
                SwingUtilities.invokeLater(new Runnable()
                {
                    public void run()
                    {
                        showMessage("Right click");
                    }
               });

                // don't show any menu
                return null;
            }
        });

        browser.navigate("http://google.com");
        browser.waitReady();
    }

    public static void main(String[] args) throws Exception
    {
        new ContextMenuActionSample().run();
    }
}
