package command;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.command.PrintCommand;
import core.BasicSample;

/**
 * This sample invokes Print dialog.
 *
 * @author Alexei Orischenko
 */
public class PrintSample extends BasicSample
{
    public PrintSample()
    {
        super("Print");
    }

    protected void execute()
    {
        getBrowser().navigate("http://google.com");
        getBrowser().waitReady();

        PrintCommand command = new PrintCommand(true);
        command.setHeader("my header 2...");
        command.setFooter("my footer 2...");

        showMessage("Invoke Print Dialog");

        getBrowser().execute(command);
    }

    public static void main(String[] args) throws Exception
    {
        new PrintSample().run();
    }
}
