/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */
package com.jniwrapper.win32.ie.samples.demo;

import com.jniwrapper.win32.shell.SHFileInfo;
import com.jniwrapper.win32.shell.ShellIcon;

import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import java.awt.Component;

class TreeCellRenderer extends DefaultTreeCellRenderer
{
    private static ImageIcon FOLDER_ICON = new ImageIcon(new ShellIcon("").toImage());
    private static ImageIcon FOLDER_OPEN_ICON =
            new ImageIcon(SHFileInfo.getFileInfo("",
                    SHFileInfo.SHGFI_SMALLICON |
            SHFileInfo.SHGFI_ICON |
            SHFileInfo.SHGFI_OPENICON).getIcon().toImage());

    private static final ImageIcon DOCUMENT_ICON = new ImageIcon(TreeCellRenderer.class.getResource("components/res/doc.gif"));

    public TreeCellRenderer()
    {
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value,
                                                  boolean sel,
                                                  boolean expanded,
                                                  boolean leaf, int row,
                                                  boolean hasFocus)
    {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (!leaf)
        {
            if (expanded)
            {
                setIcon(FOLDER_OPEN_ICON);
            }
            else
            {
                setIcon(FOLDER_ICON);
            }
        }
        else
        {
            setIcon(DOCUMENT_ICON);
        }
        return this;
    }
}
