/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */
package com.jniwrapper.win32.ie.samples.demo;

import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.event.NavigationEventAdapter;
import com.jniwrapper.win32.ie.event.StatusCode;
import com.jniwrapper.win32.ie.event.StatusEventListener;
import com.jniwrapper.win32.ie.event.WebBrowserEventsHandler;

import java.awt.Dimension;

/**
 * @author Serge Piletsky
 */
class BrowserEventsListener extends NavigationEventAdapter implements WebBrowserEventsHandler, StatusEventListener
{
    protected TabbedBrowsersPane _tabbedBrowsersPane;
    protected WebBrowser _webBrowser;

    public boolean windowClosing(boolean isChildWindow)
    {
        _webBrowser.getOleMessageLoop().doInvokeLater(new Runnable()
        {
            public void run()
            {
                if (_tabbedBrowsersPane.getTabbedPane().getTabCount() > 1)
                {
                    _tabbedBrowsersPane.removeBrowser(_webBrowser);
                }
            }
        });

        return true;
    }

    public void titleChanged(String title)
    {
        _tabbedBrowsersPane.updateBrowserTitle(_webBrowser, title);
    }

    public void backButtonEnabled(boolean enabled)
    {
        _tabbedBrowsersPane.backButtonEnabled(_webBrowser, enabled);
    }

    public void forwardButtonEnabled(boolean enabled)
    {
        _tabbedBrowsersPane.forwardButtonEnabled(_webBrowser, enabled);
    }

    public boolean beforeNavigate(WebBrowser webBrowser, String url, String targetFrameName, String postData, String headers)
    {
        return false;
    }

    public Dimension clientAreaSizeRequested(Dimension clientAreaSize)
    {
        return clientAreaSize;
    }

    public boolean beforeFileDownload()
    {
        return false;
    }

    public boolean navigationErrorOccured(WebBrowser webBrowser, String url, String frame, StatusCode statusCode)
    {
        return false;
    }

    public void progressChanged(int progress, int progressMax)
    {
        _tabbedBrowsersPane.progressChanged(progress, progressMax);
    }

    public void dataEncryptionLevelChanged(DataEncryptionLevel level)
    {
    }

    public void privacyStateChanged(boolean impacted)
    {
    }

    public void onFullScreen(boolean fullScreen)
    {
    }

    public void statusTextChanged(String text)
    {
    }
}