/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ie.samples.demo.components;

import com.jniwrapper.util.FlagSet;
import com.jniwrapper.win32.ie.samples.demo.components.FavoriteIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class URLField
extends JComboBox {
    private static final ImageIcon DOCUMENT_ICON = new ImageIcon((class$com$jniwrapper$win32$ie$samples$demo$components$URLField == null ? (class$com$jniwrapper$win32$ie$samples$demo$components$URLField = URLField.class$("com.jniwrapper.win32.ie.samples.demo.components.URLField")) : class$com$jniwrapper$win32$ie$samples$demo$components$URLField).getResource("res/doc.gif"));
    private static final String BLANK_PAGE = "about:blank";
    private Map _domain2IconMap = new HashMap();
    private URLComboBoxEditor _URLComboBoxEditor = new URLComboBoxEditor();
    static /* synthetic */ Class class$com$jniwrapper$win32$ie$samples$demo$components$URLField;
    static /* synthetic */ Class class$java$lang$String;

    public URLField() {
        this._domain2IconMap.put("", DOCUMENT_ICON);
        this.setRenderer(new URLListCellRenderer());
        this.setEditor(this._URLComboBoxEditor);
        this.setEditable(true);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageIcon imageIcon = (ImageIcon)URLField.this._domain2IconMap.get(URLField.getHost((String)URLField.this.getSelectedItem()));
                URLField.this._URLComboBoxEditor._urlIcon.setIcon(imageIcon);
                URLField.this._URLComboBoxEditor._editor.requestFocus();
            }
        });
    }

    public void setURLText(String url) {
        this._URLComboBoxEditor._editor.setText(url);
        this._URLComboBoxEditor.loadIcon(url);
    }

    public void setURL(String url) {
        if (url == null || url.length() == 0 || url.equals(BLANK_PAGE)) {
            this._URLComboBoxEditor._urlIcon.setIcon(DOCUMENT_ICON);
            this._URLComboBoxEditor._editor.setText("");
            return;
        }
        this.setSelectedItem(url);
        this._URLComboBoxEditor._editor.setText(url);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                URLField.this._URLComboBoxEditor.loadFavoriteIcon();
            }
        });
    }

    private static String getHost(String url) {
        String result = "";
        try {
            result = new URL(url).getHost();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return result;
    }

    public void requestFocus() {
        this._URLComboBoxEditor._editor.requestFocus();
    }

    public Object getSelectedItem() {
        Object result = super.getSelectedItem();
        return result == null ? "" : result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class URLListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private JLabel _urlIcon;

        public URLListCellRenderer() {
            this.setBorder(null);
            this._urlIcon = new JLabel();
            this._urlIcon.setBorder(new EmptyBorder(1, 4, 1, 0));
            this.setLayout(new BorderLayout());
            this.add((Component)this._urlIcon, "West");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = value.toString();
            this._urlIcon.setText(text);
            if (index != -1) {
                this._urlIcon.setIcon((ImageIcon)URLField.this._domain2IconMap.get(URLField.getHost(text)));
                if (isSelected) {
                    this._urlIcon.setForeground(list.getSelectionForeground());
                    this.setBackground(list.getSelectionBackground());
                } else {
                    this._urlIcon.setForeground(list.getForeground());
                    this.setBackground(list.getBackground());
                }
            }
            return this;
        }
    }

    private class URLComboBoxEditor
    extends JPanel
    implements ComboBoxEditor,
    ActionListener {
        private static final String HTTP_PROTOCOL = "http://";
        private static final String DEFAULT_URL_PATTERN = "http://www.{0}.com";
        private JTextField _editor = new JTextField();
        private JLabel _urlIcon;
        private Object _oldValue;

        public URLComboBoxEditor() {
            this.setBorder(null);
            this.setLayout(new BorderLayout());
            this.setBackground(this._editor.getBackground());
            this._urlIcon = new JLabel(DOCUMENT_ICON);
            this._urlIcon.setPreferredSize(new Dimension(20, 20));
            this._editor.setBorder(null);
            this._editor.addActionListener(this);
            this._editor.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ URLComboBoxEditor this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyTyped(KeyEvent e) {
                    String text = URLComboBoxEditor.access$400(this.this$1).getText();
                    FlagSet modifiers = new FlagSet((long)e.getModifiersEx());
                    if (e.getKeyChar() == '\n') {
                        if (modifiers.contains(128L)) {
                            String newURL = MessageFormat.format("http://www.{0}.com", text);
                            URLComboBoxEditor.access$400(this.this$1).setText(newURL);
                            URLComboBoxEditor.access$400(this.this$1).postActionEvent();
                        } else if (!text.toLowerCase().startsWith("http://")) {
                            URLComboBoxEditor.access$400(this.this$1).setText(text);
                            URLComboBoxEditor.access$400(this.this$1).postActionEvent();
                        }
                    }
                }
            });
            this.add((Component)this._urlIcon, "West");
            this.add((Component)this._editor, "Center");
        }

        public void actionPerformed(ActionEvent e) {
            this.loadFavoriteIcon();
        }

        private void loadFavoriteIcon() {
            String urlText = this._editor.getText();
            String host = URLField.getHost(urlText);
            DefaultComboBoxModel model = (DefaultComboBoxModel)URLField.this.getModel();
            if (model.getIndexOf(urlText) == -1) {
                URLField.this.insertItemAt(urlText, 0);
                if (URLField.this._domain2IconMap.containsKey(host)) {
                    this._urlIcon.setIcon((ImageIcon)URLField.this._domain2IconMap.get(host));
                } else {
                    this._urlIcon.setIcon(DOCUMENT_ICON);
                    this.loadIcon(urlText);
                }
            }
        }

        private void loadIcon(String urlText) {
            Thread loadingThread = new Thread(new Runnable(this, urlText){
                private final /* synthetic */ String val$urlText;
                private final /* synthetic */ URLComboBoxEditor this$1;
                {
                    this.this$1 = this$1;
                    this.val$urlText = val$urlText;
                }

                public void run() {
                    try {
                        ImageIcon imageIcon = new ImageIcon(new FavoriteIcon(this.val$urlText).toImage());
                        URLField.access$100(URLComboBoxEditor.access$800(this.this$1)).put(URLField.access$000(this.val$urlText), imageIcon);
                        URLComboBoxEditor.access$300(this.this$1).setIcon(imageIcon);
                    }
                    catch (Exception e) {
                        URLField.access$100(URLComboBoxEditor.access$800(this.this$1)).put(URLField.access$000(this.val$urlText), URLField.access$700());
                    }
                }
            });
            loadingThread.start();
        }

        public Component getEditorComponent() {
            return this;
        }

        public void setItem(Object anObject) {
            if (anObject != null) {
                this._editor.setText(anObject.toString());
                this._oldValue = anObject;
            } else {
                this._editor.setText("");
            }
        }

        public Object getItem() {
            Object newValue = this._editor.getText();
            if (this._oldValue != null && !(this._oldValue instanceof String)) {
                if (newValue.equals(this._oldValue.toString())) {
                    return this._oldValue;
                }
                Class<?> cls = this._oldValue.getClass();
                try {
                    Method method = cls.getMethod("valueOf", class$java$lang$String == null ? (class$java$lang$String = URLField.class$("java.lang.String")) : class$java$lang$String);
                    newValue = method.invoke(this._oldValue, this._editor.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return newValue;
        }

        public void selectAll() {
            this._editor.selectAll();
            this._editor.requestFocus();
        }

        public void addActionListener(ActionListener l) {
            this._editor.addActionListener(l);
        }

        public void removeActionListener(ActionListener l) {
            this._editor.removeActionListener(l);
        }

        static /* synthetic */ URLField access$800(URLComboBoxEditor x0) {
            return x0.URLField.this;
        }
    }
}

