/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ie.samples.demo;

import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.com.ComException;
import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.ie.ReadyState;
import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.dom.HTMLDocument;
import com.jniwrapper.win32.ie.event.NavigationEventAdapter;
import com.jniwrapper.win32.ie.event.NavigationEventListener;
import com.jniwrapper.win32.ie.event.StatusEventAdapter;
import com.jniwrapper.win32.ie.event.StatusEventListener;
import com.jniwrapper.win32.ie.samples.demo.CommandStateChangeEvent;
import com.jniwrapper.win32.ie.samples.demo.DOMStructurePanel;
import com.jniwrapper.win32.ie.samples.demo.JExplorerDemo;
import com.jniwrapper.win32.ie.samples.demo.PopupMenuTracker;
import com.jniwrapper.win32.ie.samples.demo.SettingsMenu;
import com.jniwrapper.win32.ie.samples.demo.TabbedBrowsersPane;
import com.jniwrapper.win32.ie.samples.demo.TitledPane;
import com.jniwrapper.win32.ie.samples.demo.components.ActionButton;
import com.jniwrapper.win32.ie.samples.demo.components.LineBevel;
import com.jniwrapper.win32.ie.samples.demo.components.URLField;
import com.jniwrapper.win32.ui.User32;
import com.jniwrapper.win32.ui.Wnd;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MouseEvent;

public class JExplorerDemo
implements Runnable {
    private static final Logger LOG = Logger.getInstance((Class)(class$com$jniwrapper$win32$ie$samples$demo$JExplorerDemo == null ? (class$com$jniwrapper$win32$ie$samples$demo$JExplorerDemo = JExplorerDemo.class$("com.jniwrapper.win32.ie.samples.demo.JExplorerDemo")) : class$com$jniwrapper$win32$ie$samples$demo$JExplorerDemo));
    private JTextArea _dumpArea = new JTextArea();
    private JPanel _statusPanel = new JPanel();
    private JLabel _statusText = new JLabel();
    private JSplitPane _content;
    private JSplitPane _subcontent;
    private URLField _fldGoTo;
    private JProgressBar _progressBar;
    private DOMStructurePanel _domStructurePanel;
    private TitledPane _domPane;
    private TitledPane _consolePane;
    private TabbedBrowsersPane _browsersPane;
    private JPopupMenu _browserMenu;
    private CreateNewBrowserTabAction _createNewBrowserTabAction;
    private CloseCurrentBrowserAction _closeCurrentBrowserAction;
    private SettingsMenu _settingsMenu;
    private JMenuItem _back;
    private JMenuItem _forward;
    static /* synthetic */ Class class$com$jniwrapper$win32$ie$samples$demo$JExplorerDemo;

    private static void setupLF() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
        }
        UIDefaults defaults = UIManager.getDefaults();
        defaults.put("TabbedPane.contentBorderInsets", new Insets(0, 0, 1, 0));
    }

    public static void main(String[] args) throws ComException {
        SwingUtilities.invokeLater(new JExplorerDemo());
    }

    public void run() {
        this.createGUI();
    }

    private void createGUI() {
        this._createNewBrowserTabAction = new CreateNewBrowserTabAction();
        this._closeCurrentBrowserAction = new CloseCurrentBrowserAction();
        JMenu fileMenu = new JMenu("File");
        JMenuItem exit = new JMenuItem(new ExitApplicationAction());
        JMenuItem newTab = new JMenuItem(this._createNewBrowserTabAction);
        JMenuItem closeTab = new JMenuItem(this._closeCurrentBrowserAction);
        this._browserMenu = new JPopupMenu();
        this._browserMenu.add(this._createNewBrowserTabAction);
        this._browserMenu.add(this._closeCurrentBrowserAction);
        this._browserMenu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                JExplorerDemo.this._closeCurrentBrowserAction.setEnabled(JExplorerDemo.this._browsersPane.getTabbedPane().getTabCount() > 1);
            }
        });
        fileMenu.add(newTab);
        fileMenu.add(closeTab);
        fileMenu.addSeparator();
        fileMenu.add(exit);
        this._browsersPane = new TabbedBrowsersPane(this._browserMenu, this._closeCurrentBrowserAction);
        final JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        this._content = new JSplitPane(0, true);
        this._content.setBorder(null);
        this._content.setDividerSize(2);
        this._content.setResizeWeight(0.7);
        this._subcontent = new JSplitPane(1, true);
        this._subcontent.setBorder(null);
        this._subcontent.setDividerSize(2);
        this._domStructurePanel = new DOMStructurePanel();
        this._domStructurePanel.setBorder(null);
        JPopupMenu domStructureMenu = new JPopupMenu();
        final LoadDOMStructureAction loadDOMStructureAction = new LoadDOMStructureAction();
        JMenuItem loadDomStrucure = new JMenuItem(loadDOMStructureAction);
        JMenuItem expandTree = new JMenuItem(new AbstractAction("Expand All"){

            public void actionPerformed(ActionEvent e) {
                JTree tree = JExplorerDemo.this._domStructurePanel.getTree();
                for (int i = 1; i < tree.getRowCount(); ++i) {
                    tree.expandRow(i);
                }
            }
        });
        JMenuItem collapseTree = new JMenuItem(new AbstractAction("Collapse All"){

            public void actionPerformed(ActionEvent e) {
                JTree tree = JExplorerDemo.this._domStructurePanel.getTree();
                for (int i = tree.getRowCount(); i >= 1; --i) {
                    tree.collapseRow(i);
                }
            }
        });
        domStructureMenu.add(loadDomStrucure);
        domStructureMenu.addSeparator();
        domStructureMenu.add(expandTree);
        domStructureMenu.add(collapseTree);
        new PopupMenuTracker(this._domStructurePanel.getTree(), domStructureMenu);
        final ShowDOMStructureAction showDOMStructureAction = new ShowDOMStructureAction(false);
        this._domPane = new TitledPane("DOM Structure", this._domStructurePanel, domStructureMenu, showDOMStructureAction);
        this._domPane.setVisible(false);
        this._subcontent.setLeftComponent(this._browsersPane);
        this._subcontent.setRightComponent(this._domPane);
        this._subcontent.setResizeWeight(0.7);
        this._subcontent.setDividerLocation(0.7);
        this._content.add((Component)this._subcontent, "top");
        JScrollPane scrollPane = new JScrollPane(this._dumpArea);
        this._dumpArea.setEditable(false);
        scrollPane.setBorder(null);
        JPopupMenu consoleMenu = new JPopupMenu();
        JMenuItem clearConsole = new JMenuItem(new ClearConsoleAction());
        consoleMenu.add(clearConsole);
        new PopupMenuTracker(this._dumpArea, consoleMenu);
        ShowConsoleAction showConsoleActions = new ShowConsoleAction(false);
        this._consolePane = new TitledPane("Console", scrollPane, consoleMenu, showConsoleActions);
        this._content.add((Component)this._consolePane, "bottom");
        this._consolePane.setVisible(false);
        frame.getContentPane().add((Component)this._content, "Center");
        this._progressBar = new JProgressBar();
        this._statusPanel.setLayout(new BorderLayout());
        this._statusPanel.add((Component)this._statusText, "West");
        this._statusPanel.add((Component)this._progressBar, "East");
        this._statusPanel.setPreferredSize(new Dimension(20, 18));
        LineBevel horisontalBevel = new LineBevel();
        this._statusPanel.add((Component)horisontalBevel, "North");
        frame.getContentPane().add((Component)this._statusPanel, "South");
        JPanel toolPanel = new JPanel();
        toolPanel.setLayout(new GridBagLayout());
        frame.getContentPane().add((Component)toolPanel, "North");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.setBorder(null);
        final JButton backButton = this.createButton("Back", new GoBackAction());
        backButton.setEnabled(false);
        buttonPanel.add(backButton);
        final JButton forwardButton = this.createButton("Forward", new GoForwardAction());
        forwardButton.setEnabled(false);
        buttonPanel.add(forwardButton);
        this._browsersPane.addPropertyChangeListener("commandState", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(this, evt){
                    private final /* synthetic */ PropertyChangeEvent val$evt;
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$evt = val$evt;
                    }

                    public void run() {
                        CommandStateChangeEvent event = (CommandStateChangeEvent)this.val$evt.getNewValue();
                        if (event.isBackButton()) {
                            boolean enabled = event.isEnabled();
                            4.access$300(this.this$1).setEnabled(enabled);
                            JExplorerDemo.access$500(4.access$400(this.this$1)).setEnabled(enabled);
                        } else {
                            boolean enabled = event.isEnabled();
                            4.access$600(this.this$1).setEnabled(enabled);
                            JExplorerDemo.access$700(4.access$400(this.this$1)).setEnabled(enabled);
                        }
                    }
                });
            }

            static /* synthetic */ JButton access$300(4 x0) {
                return x0.backButton;
            }

            static /* synthetic */ JExplorerDemo access$400(4 x0) {
                return x0.JExplorerDemo.this;
            }

            static /* synthetic */ JButton access$600(4 x0) {
                return x0.forwardButton;
            }
        });
        this._browsersPane.addPropertyChangeListener("progress", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(this, evt){
                    private final /* synthetic */ PropertyChangeEvent val$evt;
                    private final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$evt = val$evt;
                    }

                    public void run() {
                        Integer maxProgress = (Integer)this.val$evt.getNewValue();
                        JExplorerDemo.access$900(6.access$800(this.this$1)).setMaximum(maxProgress);
                        Integer progress = (Integer)this.val$evt.getOldValue();
                        JExplorerDemo.access$900(6.access$800(this.this$1)).setValue(progress);
                        JExplorerDemo.access$900(6.access$800(this.this$1)).setVisible(progress > 0);
                    }
                });
            }

            static /* synthetic */ JExplorerDemo access$800(6 x0) {
                return x0.JExplorerDemo.this;
            }
        });
        buttonPanel.add(this.createButton("Refresh", new RefreshAction()));
        buttonPanel.add(this.createButton("Stop", new StopAction()));
        LineBevel lineBevel = new LineBevel(1);
        lineBevel.setPreferredSize(new Dimension(2, 18));
        buttonPanel.add(lineBevel);
        buttonPanel.add(this.createButton("Home", new GoHomeAction()));
        toolPanel.add((Component)buttonPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        LineBevel bevel1 = new LineBevel();
        toolPanel.add((Component)bevel1, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JLabel lblAddress = new JLabel("Address:");
        toolPanel.add((Component)lblAddress, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this._fldGoTo = new URLField();
        this._fldGoTo.setAction(new NavigateToURLAction());
        toolPanel.add((Component)this._fldGoTo, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        final InterceptLinksAction interceptLinksAction = new InterceptLinksAction(frame, false);
        JPopupMenu browserActionsPopupMenu = new JPopupMenu();
        browserActionsPopupMenu.add(new JMenuItem(new ClearPageAction()));
        DumpHTMLAction dumpHTMLAction = new DumpHTMLAction(frame);
        browserActionsPopupMenu.add(new JMenuItem(dumpHTMLAction));
        final JCheckBoxMenuItem interceptLinksPopup = new JCheckBoxMenuItem(interceptLinksAction);
        browserActionsPopupMenu.add(interceptLinksPopup);
        this._browsersPane.getTabbedPane().addChangeListener(new ChangeListener(){
            private NavigationEventListener _listener = new NavigationEventAdapter(this){
                private final /* synthetic */ 8 this$1;
                {
                    this.this$1 = this$1;
                }

                public void entireDocumentCompleted(WebBrowser webBrowser, String url) {
                    JExplorerDemo.access$1100(8.access$1000(this.this$1)).setURLText(url);
                }
            };

            public void stateChanged(ChangeEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        WebBrowser activeBrowser = JExplorerDemo.access$000(8.access$1000(this.this$1)).getActiveBrowser();
                        if (activeBrowser == null) {
                            return;
                        }
                        JExplorerDemo.access$1200(8.access$1000(this.this$1)).setProperties(activeBrowser.getProperties());
                        String locationURL = activeBrowser.getLocationURL();
                        if (activeBrowser.getParentBrowser() != null) {
                            locationURL = activeBrowser.getParentBrowser().getLocationURL();
                        }
                        JExplorerDemo.access$1100(8.access$1000(this.this$1)).setURLText(locationURL);
                        if (!activeBrowser.getNavigationListeners().contains(8.access$1300(this.this$1))) {
                            activeBrowser.addNavigationListener(8.access$1300(this.this$1));
                            activeBrowser.addStatusListener((StatusEventListener)new StatusEventAdapter(this){
                                private final /* synthetic */ 10 this$2;
                                {
                                    this.this$2 = this$2;
                                }

                                public void statusTextChanged(String statusText) {
                                    JExplorerDemo.access$1500(8.access$1000(10.access$1400(this.this$2))).setText(statusText);
                                }
                            });
                            activeBrowser.addPropertyChangeListener("ReadyState", new PropertyChangeListener(this, activeBrowser){
                                private final /* synthetic */ WebBrowser val$activeBrowser;
                                private final /* synthetic */ 10 this$2;
                                {
                                    this.this$2 = this$2;
                                    this.val$activeBrowser = val$activeBrowser;
                                }

                                public void propertyChange(PropertyChangeEvent evt) {
                                    if (evt.getNewValue().equals(ReadyState.READYSTATE_COMPLETE)) {
                                        String locationURL = this.val$activeBrowser.getLocationURL();
                                        JExplorerDemo.access$1100(8.access$1000(10.access$1400(this.this$2))).setURL(locationURL);
                                    }
                                    SwingUtilities.invokeLater(new Runnable(this){
                                        private final /* synthetic */ 12 this$3;
                                        {
                                            this.this$3 = this$3;
                                        }

                                        public void run() {
                                            8.access$1700(10.access$1400(12.access$1600(this.this$3))).setLinkListening(8.access$1700(10.access$1400(12.access$1600(this.this$3))).isSelected());
                                        }
                                    });
                                    SwingUtilities.invokeLater(new Runnable(this){
                                        private final /* synthetic */ 12 this$3;
                                        {
                                            this.this$3 = this$3;
                                        }

                                        public void run() {
                                            if (8.access$1800(10.access$1400(12.access$1600(this.this$3))).isSelected()) {
                                                8.access$1900(10.access$1400(12.access$1600(this.this$3))).run();
                                            }
                                        }
                                    });
                                }

                                static /* synthetic */ 10 access$1600(12 x0) {
                                    return x0.this$2;
                                }
                            });
                        }
                    }

                    static /* synthetic */ 8 access$1400(10 x0) {
                        return x0.this$1;
                    }
                });
            }

            static /* synthetic */ JExplorerDemo access$1000(8 x0) {
                return x0.JExplorerDemo.this;
            }

            static /* synthetic */ NavigationEventListener access$1300(8 x0) {
                return x0._listener;
            }

            static /* synthetic */ InterceptLinksAction access$1700(8 x0) {
                return x0.interceptLinksAction;
            }

            static /* synthetic */ ShowDOMStructureAction access$1800(8 x0) {
                return x0.showDOMStructureAction;
            }

            static /* synthetic */ LoadDOMStructureAction access$1900(8 x0) {
                return x0.loadDOMStructureAction;
            }
        });
        JMenuBar mainMenu = new JMenuBar();
        JMenu view = new JMenu("View");
        JMenuItem refresh = new JMenuItem(new RefreshAction());
        JMenuItem stop = new JMenuItem(new StopAction());
        final JCheckBoxMenuItem showDOMStructure = new JCheckBoxMenuItem(showDOMStructureAction);
        showDOMStructureAction.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("Selected")) {
                    boolean value = (Boolean)evt.getNewValue();
                    showDOMStructure.setSelected(value);
                    JExplorerDemo.this._domPane.setVisible(value);
                }
            }
        });
        showDOMStructure.setSelected(false);
        final JCheckBoxMenuItem showConsole = new JCheckBoxMenuItem(showConsoleActions);
        showConsoleActions.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("Selected")) {
                    boolean value = (Boolean)evt.getNewValue();
                    showConsole.setSelected(value);
                    JExplorerDemo.this._consolePane.setVisible(value);
                }
            }
        });
        view.add(refresh);
        view.add(stop);
        view.add(new JSeparator());
        view.add(showDOMStructure);
        view.add(showConsole);
        this._back = new JMenuItem(new GoBackAction());
        this._forward = new JMenuItem(new GoForwardAction());
        JMenuItem goHome = new JMenuItem(new GoHomeAction());
        JMenu go = new JMenu("Go");
        go.add(this._back);
        go.add(this._forward);
        go.add(goHome);
        JMenu browserActionsMenu = new JMenu("Actions");
        browserActionsMenu.add(new JMenuItem(new ClearPageAction()));
        browserActionsMenu.add(new JMenuItem(dumpHTMLAction));
        browserActionsMenu.add(new JSeparator());
        final JCheckBoxMenuItem interceptLinks = new JCheckBoxMenuItem(interceptLinksAction);
        browserActionsMenu.add(interceptLinks);
        interceptLinksAction.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("Selected")) {
                    boolean value = (Boolean)evt.getNewValue();
                    interceptLinks.setSelected(value);
                    interceptLinksPopup.setSelected(value);
                }
            }
        });
        this._settingsMenu = new SettingsMenu();
        JMenu help = new JMenu("Help");
        JMenuItem about = new JMenuItem(new ShowAboutAction(frame));
        help.add(about);
        mainMenu.add(fileMenu);
        mainMenu.add(view);
        mainMenu.add(go);
        mainMenu.add(browserActionsMenu);
        mainMenu.add(this._settingsMenu);
        mainMenu.add(help);
        frame.setTitle("JExplorer Demo");
        frame.setJMenuBar(mainMenu);
        frame.setSize(830, 600);
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        this._browsersPane.createBrowser();
        frame.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                JExplorerDemo.this.setupFrameIcon(frame);
                SwingUtilities.invokeLater(new GoHomeAction());
            }
        });
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        JRootPane rootPane = frame.getRootPane();
        rootPane.getInputMap(2).put(escapeKeyStroke, "ESCAPE");
        rootPane.getActionMap().put("ESCAPE", new StopAction());
        frame.setVisible(true);
    }

    private JButton createButton(String caption, Action action) {
        ActionButton button = new ActionButton(caption, action);
        button.setPreferredSize(new Dimension(23, 20));
        String imageName = caption.toLowerCase();
        button.setIcon(new ImageIcon(this.getClass().getResource("res/" + imageName + ".png")));
        button.setRolloverIcon(new ImageIcon(this.getClass().getResource("res/" + imageName + "A.png")));
        return button;
    }

    private void setupFrameIcon(Window owner) {
        try {
            Wnd winWnd = new Wnd((Component)owner);
            Icon bigIcon = new Icon((class$com$jniwrapper$win32$ie$samples$demo$JExplorerDemo == null ? (class$com$jniwrapper$win32$ie$samples$demo$JExplorerDemo = JExplorerDemo.class$("com.jniwrapper.win32.ie.samples.demo.JExplorerDemo")) : class$com$jniwrapper$win32$ie$samples$demo$JExplorerDemo).getResourceAsStream("res/jexplorer.ico"), new Dimension(32, 32));
            Icon smallIcon = new Icon((class$com$jniwrapper$win32$ie$samples$demo$JExplorerDemo == null ? (class$com$jniwrapper$win32$ie$samples$demo$JExplorerDemo = JExplorerDemo.class$("com.jniwrapper.win32.ie.samples.demo.JExplorerDemo")) : class$com$jniwrapper$win32$ie$samples$demo$JExplorerDemo).getResourceAsStream("res/jexplorer.ico"), new Dimension(16, 16));
            winWnd.setWindowIcon(smallIcon, Icon.IconType.SMALL);
            winWnd.setWindowIcon(bigIcon, Icon.IconType.BIG);
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
        }
    }

    private void println(String str) {
        this._dumpArea.append(str + "\r\n");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ JMenuItem access$500(JExplorerDemo x0) {
        return x0._back;
    }

    static /* synthetic */ JMenuItem access$700(JExplorerDemo x0) {
        return x0._forward;
    }

    static /* synthetic */ JProgressBar access$900(JExplorerDemo x0) {
        return x0._progressBar;
    }

    static /* synthetic */ SettingsMenu access$1200(JExplorerDemo x0) {
        return x0._settingsMenu;
    }

    static /* synthetic */ JLabel access$1500(JExplorerDemo x0) {
        return x0._statusText;
    }

    static {
        JExplorerDemo.setupLF();
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
    }

    class InterceptLinksAction
    extends TriggerAction
    implements EventListener {
        private static final String ON_CLICK = "onclick";
        private Window _owner;
        private boolean _set = false;

        InterceptLinksAction(Window owner, boolean selected) {
            super("Intercept Link Clicks", selected);
            this._owner = owner;
        }

        void dumpEvent(MouseEvent event) {
            JExplorerDemo.this.println("Dumping event data:");
            JExplorerDemo.this.println("Type: " + event.getType());
            JExplorerDemo.this.println("Target UID: " + ((Element)((Object)event.getTarget())).getAttribute("uniqueID"));
            JExplorerDemo.this.println("Client coords: (" + event.getClientX() + ", " + event.getClientY() + ")");
            JExplorerDemo.this.println("Screen coords: (" + event.getScreenX() + ", " + event.getScreenY() + ")");
            JExplorerDemo.this.println("Button: " + event.getButton());
            JExplorerDemo.this.println("Ctrl pressed: " + event.getCtrlKey());
            JExplorerDemo.this.println("Alt pressed: " + event.getAltKey());
            JExplorerDemo.this.println("Shift pressed: " + event.getShiftKey());
        }

        public void handleEvent(Event evt) {
            MouseEvent event = (MouseEvent)evt;
            Element target = (Element)((Object)event.getTarget());
            this.dumpEvent(event);
            String href = target.getAttribute("href");
            NativeMessageBox messageBox = new NativeMessageBox();
            int result = messageBox.showConfirmDialog(new Wnd((Component)this._owner), "JExplorer", "The link " + href + " was clicked.\nDo you want to follow this URL?");
            if (result == 7) {
                event.preventDefault();
            }
        }

        public void setLinkListening(boolean set) {
            if (this._set != set) {
                this._set = set;
                HTMLDocument document = JExplorerDemo.this._browsersPane.getActiveBrowser().getDocument();
                NodeList links = document.getElementsByTagName("a");
                for (int i = 0; i < links.getLength(); ++i) {
                    EventTarget link = (EventTarget)((Object)links.item(i));
                    if (set) {
                        link.addEventListener(ON_CLICK, this, false);
                        continue;
                    }
                    link.removeEventListener(ON_CLICK, this, false);
                }
            }
        }

        public void onSelectionChanged() {
            this.setLinkListening(this.isSelected());
        }

        private class NativeMessageBox {
            public static final int IDNO = 7;
            public static final int YESNO = 4;
            public static final int ICONQUESTION = 32;

            private NativeMessageBox() {
            }

            public int showConfirmDialog(Wnd hWnd, String title, String message) {
                int flags = 36;
                Function function = User32.getInstance().getFunction(new FunctionName("MessageBox").toString());
                Int result = new Int();
                function.invoke((Parameter)result, (Parameter)hWnd, (Parameter)new Str(message), (Parameter)new Str(title), (Parameter)new UInt((long)flags));
                return (int)result.getValue();
            }
        }
    }

    class ShowAboutAction
    extends AbstractAction {
        Window _owner;

        ShowAboutAction(Window owner) {
            super("About JExplorer");
            this._owner = owner;
        }

        public void actionPerformed(ActionEvent e) {
            AboutDialog aboutDialog = new AboutDialog((Frame)this._owner, "About JExplorer Demo", "<html><H2>JExplorer Demo</H2><H3></H3>Copyright \u00a9 2000-2007 TeamDev Ltd.", new ImageIcon(this.getClass().getResource("res/Logo.gif")));
            aboutDialog.setVisible(true);
        }
    }

    static class AboutDialog
    extends JDialog {
        private JLabel _text = new JLabel(this){
            private final /* synthetic */ AboutDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void paint(Graphics g) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                super.paint(g);
            }
        };
        private JButton _closeButton;

        public AboutDialog(Frame owner, String title, String message, ImageIcon icon) {
            super(owner, title, true);
            AbstractAction closeAction = new AbstractAction(this, "  OK  "){
                private final /* synthetic */ AboutDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$0.setVisible(false);
                }
            };
            this._closeButton = new JButton(closeAction);
            this._closeButton.setCursor(new Cursor(12));
            Container contentPane = this.getContentPane();
            contentPane.setBackground(Color.WHITE);
            contentPane.setLayout(new BorderLayout());
            this._text.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this._text.setText(message);
            this._text.setIcon(icon);
            JPanel buttonsPanel = new JPanel(new FlowLayout(2));
            buttonsPanel.setOpaque(false);
            buttonsPanel.add(this._closeButton);
            contentPane.add((Component)this._text, "Center");
            contentPane.add((Component)buttonsPanel, "South");
            this.setResizable(false);
            this.pack();
            this.setLocationRelativeTo(null);
            KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
            JRootPane rootPane = this.getRootPane();
            rootPane.getInputMap(2).put(escapeKeyStroke, "ESCAPE");
            rootPane.getActionMap().put("ESCAPE", closeAction);
        }
    }

    class ClearPageAction
    extends AbstractAction {
        ClearPageAction() {
            super("Clear Page");
        }

        public void actionPerformed(ActionEvent e) {
            JExplorerDemo.this._browsersPane.getActiveBrowser().setContent("<html><head></head><body onload='alert(\"Cleared!\")'></body></html>");
        }
    }

    class DumpHTMLAction
    extends AbstractAction
    implements Runnable {
        Window _owner;

        DumpHTMLAction(Window owner) {
            super("Dump HTML to Console");
            this._owner = owner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this._owner.setCursor(new Cursor(3));
            try {
                JExplorerDemo.this.println(JExplorerDemo.this._browsersPane.getActiveBrowser().getContent());
            }
            finally {
                this._owner.setCursor(new Cursor(0));
            }
        }

        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(this);
        }
    }

    class CloseCurrentBrowserAction
    extends AbstractAction {
        CloseCurrentBrowserAction() {
            super("Close Tab");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl F4"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            JExplorerDemo.this._browsersPane.removeBrowser();
            WebBrowser activeBrowser = JExplorerDemo.this._browsersPane.getActiveBrowser();
            JExplorerDemo.this._fldGoTo.setURLText(activeBrowser.getLocationURL());
            JExplorerDemo.this._closeCurrentBrowserAction.setEnabled(JExplorerDemo.this._browsersPane.getTabbedPane().getTabCount() > 1);
        }
    }

    class CreateNewBrowserTabAction
    extends AbstractAction {
        CreateNewBrowserTabAction() {
            super("New Tab");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl T"));
        }

        public void actionPerformed(ActionEvent e) {
            JExplorerDemo.this._closeCurrentBrowserAction.setEnabled(true);
            JExplorerDemo.this._browsersPane.createBrowser();
            JExplorerDemo.this._fldGoTo.requestFocus();
        }
    }

    class ExitApplicationAction
    extends AbstractAction {
        ExitApplicationAction() {
            super("Exit");
        }

        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }

    class NavigateToURLAction
    extends AbstractAction {
        NavigateToURLAction() {
            super("Navigate to URL");
        }

        public void actionPerformed(ActionEvent e) {
            WebBrowser activeBrowser = JExplorerDemo.this._browsersPane.getActiveBrowser();
            String locationURL = activeBrowser.getLocationURL();
            if (locationURL.startsWith("file:///")) {
                locationURL = locationURL.substring(8);
            }
            String newLocation = (String)JExplorerDemo.this._fldGoTo.getSelectedItem();
            while (newLocation.startsWith(" ")) {
                newLocation = newLocation.substring(1);
            }
            try {
                locationURL = URLDecoder.decode(locationURL.replaceAll("/", "\\\\"), "UTF-8");
                newLocation = URLDecoder.decode(newLocation.replaceAll("/", "\\\\"), "UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                LOG.error((Object)"", (Throwable)e1);
            }
            if (!newLocation.equals(locationURL)) {
                try {
                    activeBrowser.navigate(newLocation);
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
        }
    }

    class ClearConsoleAction
    extends AbstractAction {
        ClearConsoleAction() {
            super("Clear");
        }

        public void actionPerformed(ActionEvent e) {
            JExplorerDemo.this._dumpArea.setText("");
        }
    }

    class ShowConsoleAction
    extends TriggerAction {
        ShowConsoleAction(boolean selected) {
            super("Console", selected);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt C"));
        }

        public void onSelectionChanged() {
            boolean selected = this.getSelected();
            JExplorerDemo.this._consolePane.setVisible(selected);
            if (selected) {
                JExplorerDemo.this._content.setDividerLocation(0.7);
            }
        }
    }

    class LoadDOMStructureAction
    extends AbstractAction
    implements Runnable {
        LoadDOMStructureAction() {
            super("Reload");
        }

        public void run() {
            WebBrowser activeBrowser = JExplorerDemo.this._browsersPane.getActiveBrowser();
            JExplorerDemo.this._domStructurePanel.setDocument((Node)activeBrowser.getDocument());
            JExplorerDemo.this._domStructurePanel.getTree().setSelectionRow(0);
        }

        public void actionPerformed(ActionEvent e) {
            this.run();
        }
    }

    class ShowDOMStructureAction
    extends TriggerAction {
        ShowDOMStructureAction(boolean selected) {
            super("DOM Structure", selected);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt D"));
        }

        public void onSelectionChanged() {
            boolean selected = this.getSelected();
            JExplorerDemo.this._domPane.setVisible(selected);
            if (selected) {
                JExplorerDemo.this._subcontent.setDividerLocation(0.7);
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ ShowDOMStructureAction this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        LoadDOMStructureAction action = ShowDOMStructureAction.access$2400(this.this$1).new LoadDOMStructureAction();
                        action.run();
                    }
                });
            }
        }

        static /* synthetic */ JExplorerDemo access$2400(ShowDOMStructureAction x0) {
            return x0.JExplorerDemo.this;
        }
    }

    class StopAction
    extends AbstractAction {
        StopAction() {
            super("Stop");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("CANCEL"));
        }

        public void actionPerformed(ActionEvent e) {
            JExplorerDemo.this._browsersPane.getActiveBrowser().stop();
        }
    }

    class RefreshAction
    extends AbstractAction {
        RefreshAction() {
            super("Refresh");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F5"));
        }

        public void actionPerformed(ActionEvent e) {
            JExplorerDemo.this._browsersPane.getActiveBrowser().refresh();
        }
    }

    class GoHomeAction
    extends AbstractAction
    implements Runnable {
        private static final String JNIWRAPPER_URL = "http://www.teamdev.com";

        GoHomeAction() {
            super("Home");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt HOME"));
        }

        public void run() {
            JExplorerDemo.this._fldGoTo.requestFocus();
            this.actionPerformed(null);
        }

        public void actionPerformed(ActionEvent e) {
            JExplorerDemo.this._fldGoTo.setURL(JNIWRAPPER_URL);
            JExplorerDemo.this._browsersPane.getActiveBrowser().navigate(JNIWRAPPER_URL);
        }
    }

    class GoForwardAction
    extends AbstractAction {
        GoForwardAction() {
            super("Forward");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt RIGHT"));
        }

        public void actionPerformed(ActionEvent e) {
            JExplorerDemo.this._browsersPane.getActiveBrowser().goForward();
        }
    }

    class GoBackAction
    extends AbstractAction {
        GoBackAction() {
            super("Back");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt LEFT"));
        }

        public void actionPerformed(ActionEvent e) {
            JExplorerDemo.this._browsersPane.getActiveBrowser().goBack();
        }
    }

    class TriggerAction
    extends AbstractAction
    implements PropertyChangeListener {
        public static final String PROPERTY_SELECTED = "Selected";

        TriggerAction(String name, boolean selected) {
            super(name);
            this.setSelected(selected);
            this.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(PROPERTY_SELECTED)) {
                this.onSelectionChanged();
            }
        }

        public void onSelectionChanged() {
        }

        public void setSelected(boolean value) {
            this.putValue(PROPERTY_SELECTED, new Boolean(value));
        }

        public boolean getSelected() {
            Boolean value = (Boolean)this.getValue(PROPERTY_SELECTED);
            if (value == null) {
                this.setSelected(false);
                return false;
            }
            return value;
        }

        public boolean isSelected() {
            return this.getSelected();
        }

        public final void actionPerformed(ActionEvent e) {
            this.setSelected(!this.getSelected());
        }
    }
}

