/*
 * Copyright (c) 2002-2005 DevTeam Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.jniwrapper.com/pages/jexcel/license
 */
package basics;

import com.jniwrapper.win32.jexcel.*;

import java.util.List;

/**
 * This sample demonstrates how to obtain and modify workbook window settings.
 *
 * @author Vladimir Kondrashchenko
 */
public class WindowsSample
{
    public static void main(String[] args) throws ExcelException
    {
        Application application = new Application();
        GenericWorkbook workbook = application.createWorkbook(null);

        printAllWindows(application);

        Window window = workbook.getWindow();

        System.out.println("Window properties before modifying:");
        printWindowProperties(window);

        modifyWindow(window);

        System.out.println("\nWindow properties after modifying:");
        printWindowProperties(window);

        application.close();
    }

    public static void printAllWindows(Application application)
    {
        System.out.println("Windows list:");
        List windows = application.getWindows();
        for (int i = 0; i < windows.size(); i++)
        {
            Window window = (Window)windows.get(i);
            System.out.println('\t' + window.getCaption());
        }
        System.out.println();
    }

    public static void printWindowProperties(Window window)
    {
        System.out.println("Caption: " + window.getCaption());
        System.out.println("Width: " + window.getWidth());
        System.out.println("Height: " + window.getHeight());
        System.out.println("State: " + window.getState());
        System.out.println("Zoom: " + window.getZoom());
        System.out.println("Index: " + window.getIndex());
    }

    public static void modifyWindow(Window window)
    {
        window.setCaption("New window caption");
        window.setState(Window.State.NORMAL);
        window.setHeight(450);
        window.setWidth(600);
        window.setZoom(150.0);
    }
}