/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.jexcel.samples.demo.controls;

import com.jniwrapper.win32.automation.OleMessageLoop;
import com.jniwrapper.win32.jexcel.samples.demo.controls.AbstractChooserField;
import com.jniwrapper.win32.jexcel.samples.demo.controls.ChooseColorDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;

public class ChooseColorField
extends AbstractChooserField {
    public static final String PROPERTY_COLOR = "color";
    private JPanel _colorPanel = new JPanel();
    private ChooseColorDialog _dialog;

    public ChooseColorField() {
        this.remove(this.getTextField());
        Dimension size = new Dimension(60, 20);
        this._colorPanel.setPreferredSize(size);
        this._colorPanel.setMinimumSize(size);
        this._colorPanel.setMaximumSize(size);
        this._colorPanel.setBackground(Color.black);
        this._colorPanel.setBorder(new EtchedBorder(1, Color.white, Color.gray));
        this.add((Component)this._colorPanel, "Center");
        this._colorPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ChooseColorField.this.actionPerformed(null);
                }
            }
        });
    }

    public ChooseColorField(Color color) {
        this();
        this.setColor(color);
    }

    public void actionPerformed(ActionEvent e) {
        Runnable action = new Runnable(){

            public void run() {
                ChooseColorDialog dialog = ChooseColorField.this.getDialog();
                Color oldColor = ChooseColorField.this.getColor();
                dialog.setColor(oldColor);
                if (dialog.execute()) {
                    Color newColor = dialog.getColor();
                    ChooseColorField.this.setColor(newColor);
                    ChooseColorField.this.firePropertyChange(ChooseColorField.PROPERTY_COLOR, oldColor, newColor);
                }
            }
        };
        OleMessageLoop.addAction((Runnable)action);
    }

    public ChooseColorDialog getDialog() {
        if (this._dialog == null) {
            Window parent = SwingUtilities.getWindowAncestor(this);
            this._dialog = new ChooseColorDialog(parent);
        }
        return this._dialog;
    }

    public Color getColor() {
        return this._colorPanel.getBackground();
    }

    public void setColor(Color color) {
        this._colorPanel.setBackground(color);
    }
}

