/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.jexcel.samples.demo;

import com.jniwrapper.win32.com.ComException;
import com.jniwrapper.win32.jexcel.Range;
import com.jniwrapper.win32.jexcel.format.Font;
import com.jniwrapper.win32.jexcel.format.TextAlignment;
import com.jniwrapper.win32.jexcel.format.TextOrientation;
import com.jniwrapper.win32.jexcel.samples.demo.LinkLabel;
import com.jniwrapper.win32.jexcel.samples.demo.controls.ChooseColorField;
import com.jniwrapper.win32.jexcel.ui.JWorkbook;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

class AutomationPanel
extends JPanel {
    private static final TextOrientation[] TEXT_ORIENTATIONS = new TextOrientation[]{TextOrientation.VERTICAL, TextOrientation.HORIZONTAL, TextOrientation.DOWNWARD, TextOrientation.UPWARD};
    private static final TextAlignment[] VERTICAL_ALIGNMENT = new TextAlignment[]{TextAlignment.TOP, TextAlignment.CENTER, TextAlignment.BOTTOM, TextAlignment.JUSTIFY, TextAlignment.DISTRIBUTED};
    private static final TextAlignment[] HORIZONTAL_ALIGNMENT = new TextAlignment[]{TextAlignment.GENERAL, TextAlignment.LEFT, TextAlignment.CENTER, TextAlignment.RIGHT, TextAlignment.FILL, TextAlignment.JUSTIFY, TextAlignment.DISTRIBUTED};
    private JTextField taSelection;
    private ChooseColorField _cellsBGColor;
    private ChooseColorField _cellsFontColor;
    private JComboBox _textOrientation;
    private JComboBox _verticalAlignment;
    private JComboBox _horisontalAlignment;
    private JPanel _recentFilesPanel;
    private JTextField _documentTitle;
    private JTextField _author;
    private Range _selection;
    private JWorkbook _workbook;
    static /* synthetic */ Class class$com$jniwrapper$win32$jexcel$samples$demo$AutomationPanel;

    public AutomationPanel(JWorkbook workbook) {
        super(new GridBagLayout());
        this._workbook = workbook;
        JLabel lblSelectionCaption = new JLabel("Selection:");
        this.taSelection = new JTextField("");
        this.taSelection.setEnabled(false);
        JPanel cellFormat = this.createCellFormatPanel();
        this._recentFilesPanel = new JPanel(new GridBagLayout());
        this._recentFilesPanel.setBorder(BorderFactory.createTitledBorder(null, "Recently Opened Files", 0, 0, null, Color.DARK_GRAY));
        JPanel summaryPanel = this.createSummaryPanel();
        this.add((Component)summaryPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.add((Component)this._recentFilesPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)lblSelectionCaption, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.taSelection, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)cellFormat, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel createSummaryPanel() {
        JLabel lblTitle = new JLabel("Document Title:");
        this._documentTitle = new JTextField();
        this._documentTitle.setEnabled(false);
        JLabel lblAuthor = new JLabel("Author:");
        this._author = new JTextField("Author:");
        this._author.setEnabled(false);
        JPanel summaryPanel = new JPanel(new GridBagLayout());
        summaryPanel.setBorder(BorderFactory.createTitledBorder(null, "Workbook Summary", 0, 0, null, Color.DARK_GRAY));
        summaryPanel.add((Component)lblTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        summaryPanel.add((Component)this._documentTitle, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        summaryPanel.add((Component)lblAuthor, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        summaryPanel.add((Component)this._author, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        return summaryPanel;
    }

    private JPanel createCellFormatPanel() {
        JPanel cellFormat = new JPanel(new GridBagLayout());
        cellFormat.setBorder(BorderFactory.createTitledBorder(null, "Cell Format", 0, 0, null, Color.DARK_GRAY));
        JLabel lblCellsBGColor = new JLabel("Background Color: ");
        JLabel lblCellsFontColor = new JLabel("Font Color: ");
        this._cellsBGColor = new ChooseColorField();
        this._cellsBGColor.addPropertyChangeListener("color", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (AutomationPanel.this._selection != null) {
                    try {
                        AutomationPanel.this._selection.setInteriorColor(AutomationPanel.this._cellsBGColor.getColor());
                    }
                    catch (ComException ex) {
                        AutomationPanel.this.showErrorMessage();
                    }
                }
            }
        });
        this._cellsFontColor = new ChooseColorField();
        this._cellsFontColor.addPropertyChangeListener("color", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (AutomationPanel.this._selection != null) {
                    Font font = AutomationPanel.this._selection.getFont();
                    font.setColor(AutomationPanel.this._cellsFontColor.getColor());
                    try {
                        AutomationPanel.this._selection.setFont(font);
                    }
                    catch (ComException ex) {
                        AutomationPanel.this.showErrorMessage();
                    }
                }
            }
        });
        JButton btnClear = new JButton(new AbstractAction("Clear Cells"){

            public void actionPerformed(ActionEvent e) {
                if (AutomationPanel.this._selection != null) {
                    try {
                        AutomationPanel.this._selection.clear();
                    }
                    catch (ComException ex) {
                        AutomationPanel.this.showErrorMessage();
                    }
                }
            }
        });
        JPanel clearPanel = new JPanel();
        clearPanel.add(btnClear);
        JLabel lblTextOrientation = new JLabel("Text Orientation:");
        this._textOrientation = this.createTextOrientationField();
        JLabel lblVerticalAlignment = new JLabel("Vertical Alignment:");
        this._verticalAlignment = this.createVerticalAlignmentField();
        JLabel lblHorizontalAlignment = new JLabel("Horizontal Alignment:");
        this._horisontalAlignment = this.createHorizontalAlignmentField();
        cellFormat.add((Component)lblCellsBGColor, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        cellFormat.add((Component)this._cellsBGColor, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        cellFormat.add((Component)lblCellsFontColor, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        cellFormat.add((Component)this._cellsFontColor, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        cellFormat.add((Component)lblTextOrientation, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        cellFormat.add((Component)this._textOrientation, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        cellFormat.add((Component)lblVerticalAlignment, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        cellFormat.add((Component)this._verticalAlignment, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        cellFormat.add((Component)lblHorizontalAlignment, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        cellFormat.add((Component)this._horisontalAlignment, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        cellFormat.add((Component)clearPanel, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        return cellFormat;
    }

    private JComboBox createTextOrientationField() {
        JComboBox<TextOrientation> result = new JComboBox<TextOrientation>(TEXT_ORIENTATIONS);
        result.setPreferredSize(new Dimension(100, 20));
        result.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (AutomationPanel.this._selection == null || e.getStateChange() != 1) {
                    return;
                }
                try {
                    AutomationPanel.this._selection.setTextOrientation((TextOrientation)e.getItem());
                }
                catch (ComException ex) {
                    AutomationPanel.this.showErrorMessage();
                }
            }
        });
        return result;
    }

    private JComboBox createVerticalAlignmentField() {
        JComboBox<TextAlignment> result = new JComboBox<TextAlignment>(VERTICAL_ALIGNMENT);
        result.setPreferredSize(new Dimension(100, 20));
        result.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (AutomationPanel.this._selection == null || e.getStateChange() != 1) {
                    return;
                }
                try {
                    AutomationPanel.this._selection.setVerticalAlignment((TextAlignment)e.getItem());
                }
                catch (ComException ex) {
                    AutomationPanel.this.showErrorMessage();
                }
            }
        });
        return result;
    }

    private JComboBox createHorizontalAlignmentField() {
        JComboBox<TextAlignment> result = new JComboBox<TextAlignment>(HORIZONTAL_ALIGNMENT);
        result.setPreferredSize(new Dimension(100, 20));
        result.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (AutomationPanel.this._selection == null || e.getStateChange() != 1) {
                    return;
                }
                try {
                    AutomationPanel.this._selection.setHorizontalAlignment((TextAlignment)e.getItem());
                }
                catch (ComException ex) {
                    AutomationPanel.this.showErrorMessage();
                }
            }
        });
        return result;
    }

    private boolean checkPreviewMode() {
        if (this._workbook.isPrintPreview()) {
            JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this), "Unable to process the command while the preview mode is active.", "JExcel Demo", 0);
            return true;
        }
        return false;
    }

    private void showErrorMessage() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(AutomationPanel.this), "Unable to process the command while a cell has the keyboard focus.", "JExcel Demo", 0);
            }
        });
    }

    public void updateRecentFiles() {
        List files = this._workbook.getApplication().getRecentFiles();
        this._recentFilesPanel.removeAll();
        int max_length = 30;
        for (int i = 0; i < files.size(); ++i) {
            int pos;
            final File file = (File)files.get(i);
            String path = file.getAbsolutePath();
            if (path.length() > 30 && (pos = path.lastIndexOf(92)) != -1 && 30 - path.length() + pos > 0) {
                String subPath = path.substring(0, 30 - path.length() + pos);
                path = path.substring(0, subPath.lastIndexOf(92) + 1) + "..." + path.substring(pos, path.length());
            }
            LinkLabel recentFile = new LinkLabel(path, (Icon)new ImageIcon((class$com$jniwrapper$win32$jexcel$samples$demo$AutomationPanel == null ? AutomationPanel.class$("com.jniwrapper.win32.jexcel.samples.demo.AutomationPanel") : class$com$jniwrapper$win32$jexcel$samples$demo$AutomationPanel).getResource("res/excel.gif")), new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        AutomationPanel.this.checkPreviewMode();
                        AutomationPanel.this._workbook.openWorkbook(file);
                    }
                    catch (FileNotFoundException ex) {
                        JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(AutomationPanel.this), "Cannot find file \"" + file.getAbsolutePath() + "\".", "File not found", 0);
                    }
                }
            });
            this._recentFilesPanel.add((Component)recentFile, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
        }
        this._recentFilesPanel.add((Component)new JPanel(), new GridBagConstraints(0, files.size(), 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._documentTitle.setText(this._workbook.getTitle());
        this._author.setText(this._workbook.getAuthor());
        this.revalidate();
        this.repaint();
    }

    public void setSelection(Range range) {
        this._selection = range;
        if (range == null) {
            this.taSelection.setText("");
            return;
        }
        this.taSelection.setText(this._selection.getAddress());
        if (range.getInteriorColor() != null) {
            this._cellsBGColor.setColor(range.getInteriorColor());
        } else {
            this._cellsBGColor.setColor(Color.WHITE);
        }
        if (range.getFont().getColor() != null) {
            this._cellsFontColor.setColor(range.getFont().getColor());
        } else {
            this._cellsFontColor.setColor(Color.WHITE);
        }
        this._textOrientation.setSelectedItem(this._selection.getTextOrientation());
        this._verticalAlignment.setSelectedItem(this._selection.getVerticalAlignment());
        this._horisontalAlignment.setSelectedItem(this._selection.getHorizontalAlignment());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AutomationPanel.this.repaint();
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

